/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.CallConnection;
import com.azure.communication.callingserver.CallConnectionAsync;
import com.azure.communication.callingserver.CallingServerClientBuilder;
import com.azure.communication.callingserver.ContentDownloader;
import com.azure.communication.callingserver.ServerCall;
import com.azure.communication.callingserver.ServerCallAsync;
import com.azure.communication.callingserver.implementation.AzureCommunicationCallingServerServiceImpl;
import com.azure.communication.callingserver.implementation.CallConnectionsImpl;
import com.azure.communication.callingserver.implementation.ServerCallsImpl;
import com.azure.communication.callingserver.implementation.converters.CallConnectionRequestConverter;
import com.azure.communication.callingserver.implementation.converters.CallingServerErrorConverter;
import com.azure.communication.callingserver.implementation.converters.JoinCallRequestConverter;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.implementation.models.CreateCallRequest;
import com.azure.communication.callingserver.implementation.models.CreateCallResultInternal;
import com.azure.communication.callingserver.implementation.models.JoinCallResultInternal;
import com.azure.communication.callingserver.models.CreateCallOptions;
import com.azure.communication.callingserver.models.JoinCallOptions;
import com.azure.communication.callingserver.models.ParallelDownloadOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpRange;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@ServiceClient(builder=CallingServerClientBuilder.class, isAsync=true)
public final class CallingServerAsyncClient {
    private final CallConnectionsImpl callConnectionInternal;
    private final ServerCallsImpl serverCallInternal;
    private final ClientLogger logger = new ClientLogger(CallingServerAsyncClient.class);
    private final ContentDownloader contentDownloader;

    CallingServerAsyncClient(AzureCommunicationCallingServerServiceImpl callServiceClient) {
        this.callConnectionInternal = callServiceClient.getCallConnections();
        this.serverCallInternal = callServiceClient.getServerCalls();
        this.contentDownloader = new ContentDownloader(callServiceClient.getEndpoint(), callServiceClient.getHttpPipeline());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionAsync> createCallConnection(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(targets, "'targets' cannot be null.");
            Objects.requireNonNull(createCallOptions, "'createCallOptions' cannot be null.");
            CreateCallRequest request = CallConnectionRequestConverter.convert(source, targets, createCallOptions);
            return this.callConnectionInternal.createCallAsync(request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(response -> Mono.just((Object)new CallConnectionAsync(response.getCallConnectionId(), this.callConnectionInternal)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionAsync>> createCallConnectionWithResponse(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(targets, "'targets' cannot be null.");
            Objects.requireNonNull(createCallOptions, "'CreateCallOptions' cannot be null.");
            CreateCallRequest request = CallConnectionRequestConverter.convert(source, targets, createCallOptions);
            return this.callConnectionInternal.createCallWithResponseAsync(request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new CallConnectionAsync(((CreateCallResultInternal)response.getValue()).getCallConnectionId(), this.callConnectionInternal)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<CallConnection> createCallConnectionInternal(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(targets, "'targets' cannot be null.");
            Objects.requireNonNull(createCallOptions, "'createCallOptions' cannot be null.");
            CreateCallRequest request = CallConnectionRequestConverter.convert(source, targets, createCallOptions);
            return this.callConnectionInternal.createCallAsync(request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(response -> Mono.just((Object)new CallConnection(new CallConnectionAsync(response.getCallConnectionId(), this.callConnectionInternal))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CallConnection>> createCallConnectionWithResponseInternal(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions, Context context) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(targets, "'targets' cannot be null.");
            Objects.requireNonNull(createCallOptions, "'CreateCallOptions' cannot be null.");
            CreateCallRequest request = CallConnectionRequestConverter.convert(source, targets, createCallOptions);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.createCallWithResponseAsync(request, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new CallConnection(new CallConnectionAsync(((CreateCallResultInternal)response.getValue()).getCallConnectionId(), this.callConnectionInternal))));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionAsync> joinCall(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(joinCallOptions, "'joinCallOptions' cannot be null.");
            return this.serverCallInternal.joinCallAsync(serverCallId, JoinCallRequestConverter.convert(source, joinCallOptions)).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(response -> Mono.just((Object)new CallConnectionAsync(response.getCallConnectionId(), this.callConnectionInternal)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionAsync>> joinCallWithResponse(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(joinCallOptions, "'joinCallOptions' cannot be null.");
            return this.serverCallInternal.joinCallWithResponseAsync(serverCallId, JoinCallRequestConverter.convert(source, joinCallOptions)).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new CallConnectionAsync(((JoinCallResultInternal)response.getValue()).getCallConnectionId(), this.callConnectionInternal)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<CallConnection> joinInternal(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(joinCallOptions, "'joinCallOptions' cannot be null.");
            return this.serverCallInternal.joinCallAsync(serverCallId, JoinCallRequestConverter.convert(source, joinCallOptions)).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(response -> Mono.just((Object)new CallConnection(new CallConnectionAsync(response.getCallConnectionId(), this.callConnectionInternal))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CallConnection>> joinWithResponseInternal(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions, Context context) {
        try {
            Objects.requireNonNull(source, "'source' cannot be null.");
            Objects.requireNonNull(joinCallOptions, "'joinCallOptions' cannot be null.");
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.joinCallWithResponseAsync(serverCallId, JoinCallRequestConverter.convert(source, joinCallOptions), (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new CallConnection(new CallConnectionAsync(((JoinCallResultInternal)response.getValue()).getCallConnectionId(), this.callConnectionInternal))));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public CallConnectionAsync getCallConnection(String callConnectionId) {
        Objects.requireNonNull(callConnectionId, "'callConnectionId' cannot be null.");
        return new CallConnectionAsync(callConnectionId, this.callConnectionInternal);
    }

    CallConnection getCallConnectionInternal(String callConnectionId) {
        Objects.requireNonNull(callConnectionId, "'callConnectionId' cannot be null.");
        return new CallConnection(new CallConnectionAsync(callConnectionId, this.callConnectionInternal));
    }

    public ServerCallAsync initializeServerCall(String serverCallId) {
        Objects.requireNonNull(serverCallId, "'serverCallId' cannot be null.");
        return new ServerCallAsync(serverCallId, this.serverCallInternal);
    }

    ServerCall initializeServerCallInternal(String serverCallId) {
        Objects.requireNonNull(serverCallId, "'serverCallId' cannot be null.");
        return new ServerCall(new ServerCallAsync(serverCallId, this.serverCallInternal));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ByteBuffer> downloadStream(String sourceEndpoint) {
        try {
            Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
            return this.downloadStream(sourceEndpoint, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ByteBuffer> downloadStream(String sourceEndpoint, HttpRange httpRange) {
        try {
            Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
            return this.contentDownloader.downloadStreamWithResponse(sourceEndpoint, httpRange, null).map(Response::getValue).flux().flatMap(flux -> flux);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> downloadStreamWithResponse(String sourceEndpoint, HttpRange range) {
        try {
            Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
            return this.contentDownloader.downloadStreamWithResponse(sourceEndpoint, range, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> downloadTo(String sourceEndpoint, Path destinationPath, ParallelDownloadOptions parallelDownloadOptions, boolean overwrite) {
        try {
            return this.downloadToWithResponse(sourceEndpoint, destinationPath, parallelDownloadOptions, overwrite, null).then();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> downloadToWithResponse(String sourceEndpoint, Path destinationPath, ParallelDownloadOptions parallelDownloadOptions, boolean overwrite) {
        try {
            return this.downloadToWithResponse(sourceEndpoint, destinationPath, parallelDownloadOptions, overwrite, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> downloadToWithResponse(String sourceEndpoint, OutputStream destinationStream, HttpRange httpRange, Context context) {
        return this.contentDownloader.downloadToStreamWithResponse(sourceEndpoint, destinationStream, httpRange, context);
    }

    Mono<Response<Void>> downloadToWithResponse(String sourceEndpoint, Path destinationPath, ParallelDownloadOptions parallelDownloadOptions, boolean overwrite, Context context) {
        Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
        Objects.requireNonNull(destinationPath, "'destinationPath' cannot be null");
        HashSet<StandardOpenOption> openOptions = new HashSet<StandardOpenOption>();
        if (overwrite) {
            openOptions.add(StandardOpenOption.CREATE);
        } else {
            openOptions.add(StandardOpenOption.CREATE_NEW);
        }
        openOptions.add(StandardOpenOption.WRITE);
        try {
            AsynchronousFileChannel file = AsynchronousFileChannel.open(destinationPath, openOptions, null, new FileAttribute[0]);
            return this.downloadToWithResponse(sourceEndpoint, destinationPath, file, parallelDownloadOptions, context);
        }
        catch (IOException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException(ex));
        }
    }

    Mono<Response<Void>> downloadToWithResponse(String sourceEndpoint, Path destinationPath, AsynchronousFileChannel fileChannel, ParallelDownloadOptions parallelDownloadOptions, Context context) {
        ParallelDownloadOptions finalParallelDownloadOptions = parallelDownloadOptions == null ? new ParallelDownloadOptions() : parallelDownloadOptions;
        return Mono.just((Object)fileChannel).flatMap(c -> this.contentDownloader.downloadToFileWithResponse(sourceEndpoint, (AsynchronousFileChannel)c, finalParallelDownloadOptions, context)).doFinally(signalType -> this.contentDownloader.downloadToFileCleanup(fileChannel, destinationPath, (SignalType)signalType));
    }
}

