/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.CallConnection;
import com.azure.communication.callingserver.CallingServerAsyncClient;
import com.azure.communication.callingserver.CallingServerClientBuilder;
import com.azure.communication.callingserver.ServerCall;
import com.azure.communication.callingserver.models.CreateCallOptions;
import com.azure.communication.callingserver.models.JoinCallOptions;
import com.azure.communication.callingserver.models.ParallelDownloadOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpRange;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=CallingServerClientBuilder.class)
public final class CallingServerClient {
    private final CallingServerAsyncClient callingServerAsyncClient;

    CallingServerClient(CallingServerAsyncClient callingServerAsyncClient) {
        this.callingServerAsyncClient = callingServerAsyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnection createCallConnection(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions) {
        return (CallConnection)this.callingServerAsyncClient.createCallConnectionInternal(source, targets, createCallOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnection> createCallConnectionWithResponse(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions, Context context) {
        return (Response)this.callingServerAsyncClient.createCallConnectionWithResponseInternal(source, targets, createCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnection joinCall(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions) {
        return (CallConnection)this.callingServerAsyncClient.joinInternal(serverCallId, source, joinCallOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnection> joinCallWithResponse(String serverCallId, CommunicationIdentifier source, JoinCallOptions joinCallOptions, Context context) {
        return (Response)this.callingServerAsyncClient.joinWithResponseInternal(serverCallId, source, joinCallOptions, context).block();
    }

    public CallConnection getCallConnection(String callConnectionId) {
        return this.callingServerAsyncClient.getCallConnectionInternal(callConnectionId);
    }

    public ServerCall initializeServerCall(String serverCallId) {
        return this.callingServerAsyncClient.initializeServerCallInternal(serverCallId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceEndpoint, OutputStream destinationStream, HttpRange httpRange) {
        this.downloadToWithResponse(sourceEndpoint, destinationStream, httpRange, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> downloadToWithResponse(String sourceEndpoint, OutputStream destinationStream, HttpRange httpRange, Context context) {
        Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
        Objects.requireNonNull(destinationStream, "'destinationStream' cannot be null");
        return (Response)this.callingServerAsyncClient.downloadToWithResponse(sourceEndpoint, destinationStream, httpRange, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceEndpoint, Path destinationPath, ParallelDownloadOptions parallelDownloadOptions, boolean overwrite) {
        this.downloadToWithResponse(sourceEndpoint, destinationPath, parallelDownloadOptions, overwrite, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> downloadToWithResponse(String sourceEndpoint, Path destinationPath, ParallelDownloadOptions parallelDownloadOptions, boolean overwrite, Context context) {
        Objects.requireNonNull(sourceEndpoint, "'sourceEndpoint' cannot be null");
        Objects.requireNonNull(destinationPath, "'destinationPath' cannot be null");
        return (Response)this.callingServerAsyncClient.downloadToWithResponse(sourceEndpoint, destinationPath, parallelDownloadOptions, overwrite, context).block();
    }
}

