/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.CallingServerAsyncClient;
import com.azure.communication.callingserver.CallingServerClient;
import com.azure.communication.callingserver.CallingServerServiceVersion;
import com.azure.communication.callingserver.implementation.AzureCommunicationCallingServerServiceImpl;
import com.azure.communication.callingserver.implementation.AzureCommunicationCallingServerServiceImplBuilder;
import com.azure.communication.common.implementation.CommunicationConnectionString;
import com.azure.communication.common.implementation.HmacAuthenticationPolicy;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RedirectPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={CallingServerClient.class, CallingServerAsyncClient.class})
public final class CallingServerClientBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String APP_CONFIG_PROPERTIES = "azure-communication-callingserver.properties";
    private final ClientLogger logger = new ClientLogger(CallingServerClientBuilder.class);
    private String connectionString;
    private String endpoint;
    private String hostName;
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private Configuration configuration;
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-communication-callingserver.properties");
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private RetryPolicy retryPolicy;

    public CallingServerClientBuilder endpoint(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = Objects.requireNonNull(pipeline, "'pipeline' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    CallingServerClientBuilder credential(AzureKeyCredential keyCredential) {
        this.azureKeyCredential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        this.connectionString = connectionString;
        return this;
    }

    public CallingServerClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder configuration(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "'configuration' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder serviceVersion(CallingServerServiceVersion version) {
        return this;
    }

    public CallingServerClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        return this;
    }

    public CallingServerClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.customPolicies.add(Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null."));
        return this;
    }

    public CallingServerAsyncClient buildAsyncClient() {
        return new CallingServerAsyncClient(this.createServiceImpl());
    }

    public CallingServerClient buildClient() {
        return new CallingServerClient(this.buildAsyncClient());
    }

    private AzureCommunicationCallingServerServiceImpl createServiceImpl() {
        boolean isTokenCredentialSet;
        boolean isConnectionStringSet = this.connectionString != null && !this.connectionString.trim().isEmpty();
        boolean isEndpointSet = this.endpoint != null && !this.endpoint.trim().isEmpty();
        boolean isAzureKeyCredentialSet = this.azureKeyCredential != null;
        boolean bl = isTokenCredentialSet = this.tokenCredential != null;
        if (isConnectionStringSet && isEndpointSet) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'connectionString' and 'endpoint' are set. Just one may be used."));
        }
        if (isConnectionStringSet && isAzureKeyCredentialSet) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'connectionString' and 'keyCredential' are set. Just one may be used."));
        }
        if (isConnectionStringSet && isTokenCredentialSet) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'connectionString' and 'tokenCredential' are set. Just one may be used."));
        }
        if (isAzureKeyCredentialSet && isTokenCredentialSet) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'tokenCredential' and 'keyCredential' are set. Just one may be used."));
        }
        if (isConnectionStringSet) {
            CommunicationConnectionString connectionStringObject = new CommunicationConnectionString(this.connectionString);
            String endpoint = connectionStringObject.getEndpoint();
            String accessKey = connectionStringObject.getAccessKey();
            this.endpoint(endpoint).credential(new AzureKeyCredential(accessKey));
        }
        Objects.requireNonNull(this.endpoint);
        if (isTokenCredentialSet) {
            try {
                this.hostName = this.getHostNameFromEndpoint();
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
        }
        if (this.pipeline == null) {
            Objects.requireNonNull(this.httpClient);
        }
        HttpPipeline builderPipeline = this.pipeline;
        if (this.pipeline == null) {
            builderPipeline = this.createHttpPipeline(this.httpClient);
        }
        AzureCommunicationCallingServerServiceImplBuilder clientBuilder = new AzureCommunicationCallingServerServiceImplBuilder();
        clientBuilder.endpoint(this.endpoint).pipeline(builderPipeline);
        return clientBuilder.buildClient();
    }

    public CallingServerClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    private List<HttpPipelinePolicy> createHttpPipelineAuthPolicies() {
        if (this.tokenCredential != null && this.azureKeyCredential != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'credential' and 'keyCredential' are set. Just one may be used."));
        }
        ArrayList<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
        if (this.tokenCredential != null) {
            pipelinePolicies.add((HttpPipelinePolicy)new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{"https://communication.azure.com//.default"}));
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("x-ms-host", this.hostName);
            pipelinePolicies.add((HttpPipelinePolicy)new AddHeadersPolicy(new HttpHeaders(httpHeaders)));
        } else if (this.azureKeyCredential != null) {
            pipelinePolicies.add((HttpPipelinePolicy)new HmacAuthenticationPolicy(this.azureKeyCredential));
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        return pipelinePolicies;
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient) {
        if (this.pipeline != null) {
            return this.pipeline;
        }
        ArrayList<Object> policyList = new ArrayList<Object>();
        ClientOptions buildClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        HttpLogOptions buildLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        String applicationId = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)buildClientOptions.getApplicationId())) {
            applicationId = buildClientOptions.getApplicationId();
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)buildLogOptions.getApplicationId())) {
            applicationId = buildLogOptions.getApplicationId();
        }
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policyList.add(new UserAgentPolicy(applicationId, clientName, clientVersion, this.configuration));
        policyList.add(new RequestIdPolicy());
        policyList.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policyList.add(new RedirectPolicy());
        policyList.addAll(this.createHttpPipelineAuthPolicies());
        policyList.add(new CookiePolicy());
        if (!this.customPolicies.isEmpty()) {
            policyList.addAll(this.customPolicies);
        }
        policyList.add(new HttpLoggingPolicy(this.getHttpLogOptions()));
        return new HttpPipelineBuilder().policies(policyList.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private HttpLogOptions getHttpLogOptions() {
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        return this.httpLogOptions;
    }

    private String getHostNameFromEndpoint() throws MalformedURLException {
        return new URL(this.endpoint).getHost();
    }
}

