/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.ProgressReporter;
import com.azure.communication.callingserver.models.CallingServerErrorException;
import com.azure.communication.callingserver.models.ParallelDownloadOptions;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;

class ContentDownloader {
    private final String resourceEndpoint;
    private final HttpPipeline httpPipeline;
    private final ClientLogger logger = new ClientLogger(ContentDownloader.class);

    ContentDownloader(String resourceEndpoint, HttpPipeline httpPipeline) {
        this.resourceEndpoint = resourceEndpoint;
        this.httpPipeline = httpPipeline;
    }

    Mono<Response<Void>> downloadToStreamWithResponse(String sourceEndpoint, OutputStream destinationStream, HttpRange httpRange, Context context) {
        return this.downloadStreamWithResponse(sourceEndpoint, httpRange, context).flatMap(response -> ((Flux)response.getValue()).reduce((Object)destinationStream, (outputStream, buffer) -> {
            try {
                outputStream.write(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
                return outputStream;
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(ex)));
            }
        }).thenReturn((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null)));
    }

    Mono<Response<Flux<ByteBuffer>>> downloadStreamWithResponse(String sourceEndpoint, HttpRange httpRange, Context context) {
        Mono<HttpResponse> httpResponse = this.makeDownloadRequest(sourceEndpoint, httpRange, context);
        return httpResponse.map(response -> {
            Flux<ByteBuffer> result = this.getFluxStream((HttpResponse)response, sourceEndpoint, httpRange, context);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), result);
        });
    }

    Mono<Response<Void>> downloadToFileWithResponse(String sourceEndpoint, AsynchronousFileChannel destinationFile, ParallelDownloadOptions parallelDownloadOptions, Context context) {
        ReentrantLock progressLock = new ReentrantLock();
        AtomicLong totalProgress = new AtomicLong(0L);
        Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloadFunc = range -> this.downloadStreamWithResponse(sourceEndpoint, (HttpRange)range, context);
        return this.downloadFirstChunk(parallelDownloadOptions, downloadFunc).flatMap(setupTuple2 -> {
            long newCount = (Long)setupTuple2.getT1();
            int numChunks = this.calculateNumBlocks(newCount, parallelDownloadOptions.getBlockSize());
            numChunks = numChunks == 0 ? 1 : numChunks;
            Response initialResponse = (Response)setupTuple2.getT2();
            return Flux.range((int)0, (int)numChunks).flatMap(chunkNum -> this.downloadChunk((Integer)chunkNum, (Response<Flux<ByteBuffer>>)initialResponse, parallelDownloadOptions, newCount, downloadFunc, response -> ContentDownloader.writeBodyToFile((Response<Flux<ByteBuffer>>)response, destinationFile, chunkNum.intValue(), parallelDownloadOptions, progressLock, totalProgress).flux())).then(Mono.just((Object)new SimpleResponse(initialResponse, null)));
        });
    }

    private Flux<ByteBuffer> getFluxStream(HttpResponse httpResponse, String sourceEndpoint, HttpRange httpRange, Context context) {
        return FluxUtil.createRetriableDownloadFlux(() -> this.getResponseBody(httpResponse), (throwable, aLong) -> {
            CallingServerErrorException exception;
            if (throwable instanceof CallingServerErrorException && (exception = (CallingServerErrorException)((Object)((Object)throwable))).getResponse().getStatusCode() == 416) {
                return this.makeDownloadRequest(sourceEndpoint, null, context).map(this::getResponseBody).flux().flatMap(flux -> flux);
            }
            HttpRange range = httpRange != null ? new HttpRange(aLong + 1L, Long.valueOf(httpRange.getLength() - aLong - 1L)) : new HttpRange(aLong + 1L);
            return this.makeDownloadRequest(sourceEndpoint, range, context).map(this::getResponseBody).flux().flatMap(flux -> flux);
        }, (int)4);
    }

    private Flux<ByteBuffer> getResponseBody(HttpResponse response) {
        switch (response.getStatusCode()) {
            case 200: 
            case 206: {
                return response.getBody();
            }
            case 416: {
                return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)((Object)new CallingServerErrorException(this.formatExceptionMessage(response), response)));
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)((Object)new CallingServerErrorException(this.formatExceptionMessage(response), response)));
    }

    private String formatExceptionMessage(HttpResponse httpResponse) {
        return String.format("Service Request failed!%nStatus: %s", httpResponse.getStatusCode());
    }

    private Mono<HttpResponse> makeDownloadRequest(String sourceEndpoint, HttpRange httpRange, Context context) {
        HttpRequest request = this.getHttpRequest(sourceEndpoint, httpRange);
        URL urlToSignWith = this.getUrlToSignRequestWith(sourceEndpoint);
        Context finalContext = context == null ? new Context((Object)"hmacSignatureURL", (Object)urlToSignWith) : context.addData((Object)"hmacSignatureURL", (Object)urlToSignWith);
        return this.httpPipeline.send(request, finalContext);
    }

    private URL getUrlToSignRequestWith(String endpoint) {
        try {
            String path = new URL(endpoint).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return new URL(this.resourceEndpoint + path);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(ex));
        }
    }

    private HttpRequest getHttpRequest(String sourceEndpoint, HttpRange httpRange) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, sourceEndpoint);
        if (null != httpRange) {
            request.setHeader("Range", httpRange.toString());
        }
        return request;
    }

    private Mono<Tuple2<Long, Response<Flux<ByteBuffer>>>> downloadFirstChunk(ParallelDownloadOptions parallelDownloadOptions, Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloader) {
        return downloader.apply(new HttpRange(0L, Long.valueOf(parallelDownloadOptions.getBlockSize()))).subscribeOn(Schedulers.boundedElastic()).flatMap(response -> {
            long totalLength = this.extractTotalBlobLength(response.getHeaders().getValue("Content-Range"));
            return Mono.zip((Mono)Mono.just((Object)totalLength), (Mono)Mono.just((Object)response));
        });
    }

    private long extractTotalBlobLength(String contentRange) {
        return contentRange == null ? 0L : Long.parseLong(contentRange.split("/")[1]);
    }

    private int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    private <T> Flux<T> downloadChunk(Integer chunkNum, Response<Flux<ByteBuffer>> initialResponse, ParallelDownloadOptions parallelDownloadOptions, long newCount, Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloader, Function<Response<Flux<ByteBuffer>>, Flux<T>> returnTransformer) {
        if (chunkNum == 0) {
            return returnTransformer.apply(initialResponse);
        }
        long modifier = chunkNum.longValue() * parallelDownloadOptions.getBlockSize();
        long chunkSizeActual = Math.min(parallelDownloadOptions.getBlockSize(), newCount - modifier);
        HttpRange chunkRange = new HttpRange(modifier, Long.valueOf(chunkSizeActual));
        return downloader.apply(chunkRange).subscribeOn(Schedulers.boundedElastic()).flatMapMany(returnTransformer);
    }

    private static Mono<Void> writeBodyToFile(Response<Flux<ByteBuffer>> response, AsynchronousFileChannel file, long chunkNum, ParallelDownloadOptions parallelDownloadOptions, Lock progressLock, AtomicLong totalProgress) {
        Flux<ByteBuffer> data = (Flux<ByteBuffer>)response.getValue();
        data = ProgressReporter.addParallelProgressReporting(data, parallelDownloadOptions.getProgressReceiver(), progressLock, totalProgress);
        return FluxUtil.writeFile(data, (AsynchronousFileChannel)file, (long)(chunkNum * parallelDownloadOptions.getBlockSize()));
    }

    void downloadToFileCleanup(AsynchronousFileChannel channel, Path filePath, SignalType signalType) {
        try {
            channel.close();
            if (!signalType.equals((Object)SignalType.ON_COMPLETE)) {
                Files.deleteIfExists(filePath);
                this.logger.verbose("Downloading to file failed. Cleaning up resources.");
            }
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }
}

