/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.ServerCallAsync;
import com.azure.communication.callingserver.models.AddParticipantResult;
import com.azure.communication.callingserver.models.CallRecordingProperties;
import com.azure.communication.callingserver.models.PlayAudioOptions;
import com.azure.communication.callingserver.models.PlayAudioResult;
import com.azure.communication.callingserver.models.StartCallRecordingResult;
import com.azure.communication.callingserver.models.StartRecordingOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

public final class ServerCall {
    private final ServerCallAsync serverCallAsync;

    ServerCall(ServerCallAsync serverCallAsync) {
        this.serverCallAsync = serverCallAsync;
    }

    public String getServerCallId() {
        return this.serverCallAsync.getServerCallId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResult addParticipant(CommunicationIdentifier participant, String callBackUri, String alternateCallerId, String operationContext) {
        return (AddParticipantResult)this.serverCallAsync.addParticipant(participant, callBackUri, alternateCallerId, operationContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResult> addParticipantWithResponse(CommunicationIdentifier participant, String callBackUri, String alternateCallerId, String operationContext, Context context) {
        return (Response)this.serverCallAsync.addParticipantWithResponse(participant, callBackUri, alternateCallerId, operationContext, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeParticipant(String participantId) {
        this.serverCallAsync.removeParticipant(participantId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeParticipantWithResponse(String participantId, Context context) {
        return (Response)this.serverCallAsync.removeParticipantWithResponse(participantId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StartCallRecordingResult startRecording(String recordingStateCallbackUri) {
        return (StartCallRecordingResult)this.serverCallAsync.startRecording(recordingStateCallbackUri).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StartCallRecordingResult> startRecordingWithResponse(String recordingStateCallbackUri, StartRecordingOptions startRecordingOptions, Context context) {
        return (Response)this.serverCallAsync.startRecordingWithResponse(recordingStateCallbackUri, startRecordingOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopRecording(String recordingId) {
        this.serverCallAsync.stopRecording(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.serverCallAsync.stopRecordingWithResponse(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pauseRecording(String recordingId) {
        this.serverCallAsync.pauseRecording(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.serverCallAsync.pauseRecordingWithResponse(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resumeRecording(String recordingId) {
        this.serverCallAsync.resumeRecording(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.serverCallAsync.resumeRecordingWithResponse(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallRecordingProperties getRecordingState(String recordingId) {
        return (CallRecordingProperties)this.serverCallAsync.getRecordingState(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallRecordingProperties> getRecordingStateWithResponse(String recordingId, Context context) {
        return (Response)this.serverCallAsync.getRecordingStateWithResponse(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResult playAudio(String audioFileUri, String audioFileId, String callbackUri, String operationContext) {
        return (PlayAudioResult)this.serverCallAsync.playAudioInternal(audioFileUri, audioFileId, callbackUri, operationContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResult playAudio(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return (PlayAudioResult)this.serverCallAsync.playAudioInternal(audioFileUri, playAudioOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PlayAudioResult> playAudioWithResponse(String audioFileUri, PlayAudioOptions playAudioOptions, Context context) {
        return (Response)this.serverCallAsync.playAudioWithResponseInternal(audioFileUri, playAudioOptions, context).block();
    }
}

