/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.implementation.ServerCallsImpl;
import com.azure.communication.callingserver.implementation.converters.AddParticipantRequestConverter;
import com.azure.communication.callingserver.implementation.converters.CallingServerErrorConverter;
import com.azure.communication.callingserver.implementation.converters.PlayAudioResultConverter;
import com.azure.communication.callingserver.implementation.models.AddParticipantRequest;
import com.azure.communication.callingserver.implementation.models.AddParticipantResultInternal;
import com.azure.communication.callingserver.implementation.models.CallRecordingPropertiesInternal;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.implementation.models.PlayAudioRequest;
import com.azure.communication.callingserver.implementation.models.PlayAudioResultInternal;
import com.azure.communication.callingserver.implementation.models.StartCallRecordingRequest;
import com.azure.communication.callingserver.implementation.models.StartCallRecordingResultInternal;
import com.azure.communication.callingserver.models.AddParticipantResult;
import com.azure.communication.callingserver.models.CallRecordingProperties;
import com.azure.communication.callingserver.models.PlayAudioOptions;
import com.azure.communication.callingserver.models.PlayAudioResult;
import com.azure.communication.callingserver.models.StartCallRecordingResult;
import com.azure.communication.callingserver.models.StartRecordingOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class ServerCallAsync {
    private final String serverCallId;
    private final ServerCallsImpl serverCallInternal;
    private final ClientLogger logger = new ClientLogger(ServerCallAsync.class);

    ServerCallAsync(String serverCallId, ServerCallsImpl serverCallInternal) {
        this.serverCallId = serverCallId;
        this.serverCallInternal = serverCallInternal;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResult> addParticipant(CommunicationIdentifier participant, String callBackUri, String alternateCallerId, String operationContext) {
        try {
            Objects.requireNonNull(participant, "'participant' cannot be null.");
            AddParticipantRequest request = AddParticipantRequestConverter.convert(participant, alternateCallerId, operationContext, callBackUri);
            return this.serverCallInternal.addParticipantAsync(this.serverCallId, request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)new AddParticipantResult(result.getParticipantId())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResult>> addParticipantWithResponse(CommunicationIdentifier participant, String callBackUri, String alternateCallerId, String operationContext) {
        return this.addParticipantWithResponse(participant, callBackUri, alternateCallerId, operationContext, null);
    }

    Mono<Response<AddParticipantResult>> addParticipantWithResponse(CommunicationIdentifier participant, String callBackUri, String alternateCallerId, String operationContext, Context context) {
        try {
            Objects.requireNonNull(participant, "'participant' cannot be null.");
            AddParticipantRequest request = AddParticipantRequestConverter.convert(participant, alternateCallerId, operationContext, callBackUri);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.addParticipantWithResponseAsync(this.serverCallId, request, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new AddParticipantResult(((AddParticipantResultInternal)response.getValue()).getParticipantId())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipant(String participantId) {
        try {
            return this.serverCallInternal.removeParticipantAsync(this.serverCallId, participantId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponse(String participantId) {
        return this.removeParticipantWithResponse(participantId, null);
    }

    Mono<Response<Void>> removeParticipantWithResponse(String participantId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.removeParticipantWithResponseAsync(this.serverCallId, participantId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StartCallRecordingResult> startRecording(String recordingStateCallbackUri) {
        try {
            Objects.requireNonNull(recordingStateCallbackUri, "'recordingStateCallbackUri' cannot be null.");
            if (!Boolean.TRUE.equals(new URI(recordingStateCallbackUri).isAbsolute())) {
                throw this.logger.logExceptionAsError((RuntimeException)new InvalidParameterException("'recordingStateCallbackUri' has to be an absolute Uri"));
            }
            StartCallRecordingRequest request = new StartCallRecordingRequest();
            request.setRecordingStateCallbackUri(recordingStateCallbackUri);
            return this.serverCallInternal.startRecordingAsync(this.serverCallId, request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)new StartCallRecordingResult(result.getRecordingId())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
        catch (URISyntaxException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException(ex.getMessage()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StartCallRecordingResult>> startRecordingWithResponse(String recordingStateCallbackUri, StartRecordingOptions startRecordingOptions, Context context) {
        try {
            Objects.requireNonNull(recordingStateCallbackUri, "'recordingStateCallbackUri' cannot be null.");
            if (!Boolean.TRUE.equals(new URI(recordingStateCallbackUri).isAbsolute())) {
                throw this.logger.logExceptionAsError((RuntimeException)new InvalidParameterException("'recordingStateCallbackUri' has to be an absolute Uri"));
            }
            StartCallRecordingRequest request = new StartCallRecordingRequest();
            request.setRecordingStateCallbackUri(recordingStateCallbackUri);
            if (startRecordingOptions != null) {
                request.setRecordingChannelType(startRecordingOptions.getRecordingChannel());
                request.setRecordingContentType(startRecordingOptions.getRecordingContent());
                request.setRecordingFormatType(startRecordingOptions.getRecordingFormat());
            }
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.startRecordingWithResponseAsync(this.serverCallId, request, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new StartCallRecordingResult(((StartCallRecordingResultInternal)response.getValue()).getRecordingId())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
        catch (URISyntaxException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException(ex.getMessage()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopRecording(String recordingId) {
        try {
            return this.serverCallInternal.stopRecordingAsync(this.serverCallId, recordingId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponse(String recordingId) {
        return this.stopRecordingWithResponse(recordingId, null);
    }

    Mono<Response<Void>> stopRecordingWithResponse(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.stopRecordingWithResponseAsync(this.serverCallId, recordingId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseRecording(String recordingId) {
        try {
            return this.serverCallInternal.pauseRecordingAsync(this.serverCallId, recordingId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponse(String recordingId) {
        return this.pauseRecordingWithResponse(recordingId, null);
    }

    Mono<Response<Void>> pauseRecordingWithResponse(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.pauseRecordingWithResponseAsync(this.serverCallId, recordingId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeRecording(String recordingId) {
        try {
            return this.serverCallInternal.resumeRecordingAsync(this.serverCallId, recordingId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponse(String recordingId) {
        return this.resumeRecordingWithResponse(recordingId, null);
    }

    Mono<Response<Void>> resumeRecordingWithResponse(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.resumeRecordingWithResponseAsync(this.serverCallId, recordingId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallRecordingProperties> getRecordingState(String recordingId) {
        try {
            return this.serverCallInternal.getRecordingPropertiesAsync(this.serverCallId, recordingId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)new CallRecordingProperties(result.getRecordingState())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallRecordingProperties>> getRecordingStateWithResponse(String recordingId) {
        return this.getRecordingStateWithResponse(recordingId, null);
    }

    Mono<Response<CallRecordingProperties>> getRecordingStateWithResponse(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.getRecordingPropertiesWithResponseAsync(this.serverCallId, recordingId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new CallRecordingProperties(((CallRecordingPropertiesInternal)response.getValue()).getRecordingState())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResult> playAudio(String audioFileUri, String audioFileId, String callbackUri, String operationContext) {
        return this.playAudioInternal(audioFileUri, audioFileId, callbackUri, operationContext);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResult> playAudio(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return this.playAudioInternal(audioFileUri, playAudioOptions);
    }

    Mono<PlayAudioResult> playAudioInternal(String audioFileUri, String audioFileId, String callbackUri, String operationContext) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest playAudioRequest = new PlayAudioRequest().setAudioFileUri(audioFileUri).setLoop(false).setAudioFileId(audioFileId).setOperationContext(operationContext).setCallbackUri(callbackUri);
            return this.playAudioInternal(playAudioRequest);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PlayAudioResult> playAudioInternal(String audioFileUri, PlayAudioOptions playAudioOptions) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest request = new PlayAudioRequest().setAudioFileUri(audioFileUri);
            if (playAudioOptions != null) {
                request.setLoop(false).setOperationContext(playAudioOptions.getOperationContext()).setAudioFileId(playAudioOptions.getAudioFileId()).setCallbackUri(playAudioOptions.getCallbackUri());
            }
            return this.playAudioInternal(request);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PlayAudioResult> playAudioInternal(PlayAudioRequest playAudioRequest) {
        try {
            return this.serverCallInternal.playAudioAsync(this.serverCallId, playAudioRequest).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)PlayAudioResultConverter.convert(result)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResult>> playAudioWithResponse(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return this.playAudioWithResponseInternal(audioFileUri, playAudioOptions, null);
    }

    Mono<Response<PlayAudioResult>> playAudioWithResponseInternal(String audioFileUri, PlayAudioOptions playAudioOptions, Context context) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest request = new PlayAudioRequest().setAudioFileUri(audioFileUri);
            if (playAudioOptions != null) {
                request.setLoop(false).setOperationContext(playAudioOptions.getOperationContext()).setAudioFileId(playAudioOptions.getAudioFileId()).setCallbackUri(playAudioOptions.getCallbackUri());
            }
            return this.playAudioWithResponse(request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PlayAudioResult>> playAudioWithResponse(PlayAudioRequest playAudioRequest, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.serverCallInternal.playAudioWithResponseAsync(this.serverCallId, playAudioRequest, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)PlayAudioResultConverter.convert((PlayAudioResultInternal)response.getValue())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

