/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.implementation;

import com.azure.communication.callingserver.implementation.AzureCommunicationCallingServerServiceImpl;
import com.azure.communication.callingserver.implementation.models.AddParticipantRequest;
import com.azure.communication.callingserver.implementation.models.AddParticipantResultInternal;
import com.azure.communication.callingserver.implementation.models.CancelAllMediaOperationsRequest;
import com.azure.communication.callingserver.implementation.models.CancelAllMediaOperationsResultInternal;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.implementation.models.CreateCallRequest;
import com.azure.communication.callingserver.implementation.models.CreateCallResultInternal;
import com.azure.communication.callingserver.implementation.models.PlayAudioRequest;
import com.azure.communication.callingserver.implementation.models.PlayAudioResultInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class CallConnectionsImpl {
    private final CallConnectionsService service;
    private final AzureCommunicationCallingServerServiceImpl client;

    CallConnectionsImpl(AzureCommunicationCallingServerServiceImpl client) {
        this.service = (CallConnectionsService)RestProxy.create(CallConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResultInternal>> createCallWithResponseAsync(CreateCallRequest callRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createCall(this.client.getEndpoint(), this.client.getApiVersion(), callRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResultInternal>> createCallWithResponseAsync(CreateCallRequest callRequest, Context context) {
        String accept = "application/json";
        return this.service.createCall(this.client.getEndpoint(), this.client.getApiVersion(), callRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResultInternal> createCallAsync(CreateCallRequest callRequest) {
        return this.createCallWithResponseAsync(callRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CreateCallResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResultInternal> createCallAsync(CreateCallRequest callRequest, Context context) {
        return this.createCallWithResponseAsync(callRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CreateCallResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateCallResultInternal createCall(CreateCallRequest callRequest) {
        return (CreateCallResultInternal)this.createCallAsync(callRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateCallResultInternal> createCallWithResponse(CreateCallRequest callRequest, Context context) {
        return (Response)this.createCallWithResponseAsync(callRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId) {
        return this.hangupCallWithResponseAsync(callConnectionId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId, Context context) {
        return this.hangupCallWithResponseAsync(callConnectionId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hangupCall(String callConnectionId) {
        this.hangupCallAsync(callConnectionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> hangupCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.hangupCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResultInternal>> playAudioWithResponseAsync(String callConnectionId, PlayAudioRequest request) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.playAudio(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResultInternal>> playAudioWithResponseAsync(String callConnectionId, PlayAudioRequest request, Context context) {
        String accept = "application/json";
        return this.service.playAudio(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResultInternal> playAudioAsync(String callConnectionId, PlayAudioRequest request) {
        return this.playAudioWithResponseAsync(callConnectionId, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PlayAudioResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResultInternal> playAudioAsync(String callConnectionId, PlayAudioRequest request, Context context) {
        return this.playAudioWithResponseAsync(callConnectionId, request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PlayAudioResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResultInternal playAudio(String callConnectionId, PlayAudioRequest request) {
        return (PlayAudioResultInternal)this.playAudioAsync(callConnectionId, request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PlayAudioResultInternal> playAudioWithResponse(String callConnectionId, PlayAudioRequest request, Context context) {
        return (Response)this.playAudioWithResponseAsync(callConnectionId, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CancelAllMediaOperationsResultInternal>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), cancelAllMediaOperationRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CancelAllMediaOperationsResultInternal>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest, Context context) {
        String accept = "application/json";
        return this.service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), cancelAllMediaOperationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CancelAllMediaOperationsResultInternal> cancelAllMediaOperationsAsync(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, cancelAllMediaOperationRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CancelAllMediaOperationsResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CancelAllMediaOperationsResultInternal> cancelAllMediaOperationsAsync(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest, Context context) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, cancelAllMediaOperationRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CancelAllMediaOperationsResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CancelAllMediaOperationsResultInternal cancelAllMediaOperations(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest) {
        return (CancelAllMediaOperationsResultInternal)this.cancelAllMediaOperationsAsync(callConnectionId, cancelAllMediaOperationRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CancelAllMediaOperationsResultInternal> cancelAllMediaOperationsWithResponse(String callConnectionId, CancelAllMediaOperationsRequest cancelAllMediaOperationRequest, Context context) {
        return (Response)this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, cancelAllMediaOperationRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResultInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequest addParticipantRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), addParticipantRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResultInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequest addParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), addParticipantRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResultInternal> addParticipantAsync(String callConnectionId, AddParticipantRequest addParticipantRequest) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResultInternal> addParticipantAsync(String callConnectionId, AddParticipantRequest addParticipantRequest, Context context) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResultInternal addParticipant(String callConnectionId, AddParticipantRequest addParticipantRequest) {
        return (AddParticipantResultInternal)this.addParticipantAsync(callConnectionId, addParticipantRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResultInternal> addParticipantWithResponse(String callConnectionId, AddParticipantRequest addParticipantRequest, Context context) {
        return (Response)this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponseAsync(String callConnectionId, String participantId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeParticipant(this.client.getEndpoint(), callConnectionId, participantId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponseAsync(String callConnectionId, String participantId, Context context) {
        String accept = "application/json";
        return this.service.removeParticipant(this.client.getEndpoint(), callConnectionId, participantId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipantAsync(String callConnectionId, String participantId) {
        return this.removeParticipantWithResponseAsync(callConnectionId, participantId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipantAsync(String callConnectionId, String participantId, Context context) {
        return this.removeParticipantWithResponseAsync(callConnectionId, participantId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeParticipant(String callConnectionId, String participantId) {
        this.removeParticipantAsync(callConnectionId, participantId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeParticipantWithResponse(String callConnectionId, String participantId, Context context) {
        return (Response)this.removeParticipantWithResponseAsync(callConnectionId, participantId, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    private static interface CallConnectionsService {
        @Post(value="/calling/callConnections")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CreateCallResultInternal>> createCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CreateCallRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}/:hangup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> hangupCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}/:playAudio")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PlayAudioResultInternal>> playAudio(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PlayAudioRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}/:cancelAllMediaOperations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CancelAllMediaOperationsResultInternal>> cancelAllMediaOperations(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CancelAllMediaOperationsRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}/participants")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<AddParticipantResultInternal>> addParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AddParticipantRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/calling/callConnections/{callConnectionId}/participants/{participantId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> removeParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @PathParam(value="participantId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

