/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.implementation;

import com.azure.communication.callingserver.implementation.AzureCommunicationCallingServerServiceImpl;
import com.azure.communication.callingserver.implementation.models.AddParticipantRequest;
import com.azure.communication.callingserver.implementation.models.AddParticipantResultInternal;
import com.azure.communication.callingserver.implementation.models.CallRecordingPropertiesInternal;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.implementation.models.JoinCallRequest;
import com.azure.communication.callingserver.implementation.models.JoinCallResultInternal;
import com.azure.communication.callingserver.implementation.models.PlayAudioRequest;
import com.azure.communication.callingserver.implementation.models.PlayAudioResultInternal;
import com.azure.communication.callingserver.implementation.models.StartCallRecordingRequest;
import com.azure.communication.callingserver.implementation.models.StartCallRecordingResultInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class ServerCallsImpl {
    private final ServerCallsService service;
    private final AzureCommunicationCallingServerServiceImpl client;

    ServerCallsImpl(AzureCommunicationCallingServerServiceImpl client) {
        this.service = (ServerCallsService)RestProxy.create(ServerCallsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResultInternal>> addParticipantWithResponseAsync(String serverCallId, AddParticipantRequest addParticipantRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addParticipant(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), addParticipantRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResultInternal>> addParticipantWithResponseAsync(String serverCallId, AddParticipantRequest addParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.addParticipant(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), addParticipantRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResultInternal> addParticipantAsync(String serverCallId, AddParticipantRequest addParticipantRequest) {
        return this.addParticipantWithResponseAsync(serverCallId, addParticipantRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResultInternal> addParticipantAsync(String serverCallId, AddParticipantRequest addParticipantRequest, Context context) {
        return this.addParticipantWithResponseAsync(serverCallId, addParticipantRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResultInternal addParticipant(String serverCallId, AddParticipantRequest addParticipantRequest) {
        return (AddParticipantResultInternal)this.addParticipantAsync(serverCallId, addParticipantRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResultInternal> addParticipantWithResponse(String serverCallId, AddParticipantRequest addParticipantRequest, Context context) {
        return (Response)this.addParticipantWithResponseAsync(serverCallId, addParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponseAsync(String serverCallId, String participantId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeParticipant(this.client.getEndpoint(), serverCallId, participantId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponseAsync(String serverCallId, String participantId, Context context) {
        String accept = "application/json";
        return this.service.removeParticipant(this.client.getEndpoint(), serverCallId, participantId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipantAsync(String serverCallId, String participantId) {
        return this.removeParticipantWithResponseAsync(serverCallId, participantId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipantAsync(String serverCallId, String participantId, Context context) {
        return this.removeParticipantWithResponseAsync(serverCallId, participantId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeParticipant(String serverCallId, String participantId) {
        this.removeParticipantAsync(serverCallId, participantId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeParticipantWithResponse(String serverCallId, String participantId, Context context) {
        return (Response)this.removeParticipantWithResponseAsync(serverCallId, participantId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StartCallRecordingResultInternal>> startRecordingWithResponseAsync(String serverCallId, StartCallRecordingRequest request) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startRecording(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StartCallRecordingResultInternal>> startRecordingWithResponseAsync(String serverCallId, StartCallRecordingRequest request, Context context) {
        String accept = "application/json";
        return this.service.startRecording(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StartCallRecordingResultInternal> startRecordingAsync(String serverCallId, StartCallRecordingRequest request) {
        return this.startRecordingWithResponseAsync(serverCallId, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((StartCallRecordingResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StartCallRecordingResultInternal> startRecordingAsync(String serverCallId, StartCallRecordingRequest request, Context context) {
        return this.startRecordingWithResponseAsync(serverCallId, request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((StartCallRecordingResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StartCallRecordingResultInternal startRecording(String serverCallId, StartCallRecordingRequest request) {
        return (StartCallRecordingResultInternal)this.startRecordingAsync(serverCallId, request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StartCallRecordingResultInternal> startRecordingWithResponse(String serverCallId, StartCallRecordingRequest request, Context context) {
        return (Response)this.startRecordingWithResponseAsync(serverCallId, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallRecordingPropertiesInternal>> getRecordingPropertiesWithResponseAsync(String serverCallId, String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRecordingProperties(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallRecordingPropertiesInternal>> getRecordingPropertiesWithResponseAsync(String serverCallId, String recordingId, Context context) {
        String accept = "application/json";
        return this.service.getRecordingProperties(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallRecordingPropertiesInternal> getRecordingPropertiesAsync(String serverCallId, String recordingId) {
        return this.getRecordingPropertiesWithResponseAsync(serverCallId, recordingId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallRecordingPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallRecordingPropertiesInternal> getRecordingPropertiesAsync(String serverCallId, String recordingId, Context context) {
        return this.getRecordingPropertiesWithResponseAsync(serverCallId, recordingId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallRecordingPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallRecordingPropertiesInternal getRecordingProperties(String serverCallId, String recordingId) {
        return (CallRecordingPropertiesInternal)this.getRecordingPropertiesAsync(serverCallId, recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallRecordingPropertiesInternal> getRecordingPropertiesWithResponse(String serverCallId, String recordingId, Context context) {
        return (Response)this.getRecordingPropertiesWithResponseAsync(serverCallId, recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String serverCallId, String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String serverCallId, String recordingId, Context context) {
        String accept = "application/json";
        return this.service.stopRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String serverCallId, String recordingId) {
        return this.stopRecordingWithResponseAsync(serverCallId, recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String serverCallId, String recordingId, Context context) {
        return this.stopRecordingWithResponseAsync(serverCallId, recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopRecording(String serverCallId, String recordingId) {
        this.stopRecordingAsync(serverCallId, recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopRecordingWithResponse(String serverCallId, String recordingId, Context context) {
        return (Response)this.stopRecordingWithResponseAsync(serverCallId, recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String serverCallId, String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.pauseRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String serverCallId, String recordingId, Context context) {
        String accept = "application/json";
        return this.service.pauseRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String serverCallId, String recordingId) {
        return this.pauseRecordingWithResponseAsync(serverCallId, recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String serverCallId, String recordingId, Context context) {
        return this.pauseRecordingWithResponseAsync(serverCallId, recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pauseRecording(String serverCallId, String recordingId) {
        this.pauseRecordingAsync(serverCallId, recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseRecordingWithResponse(String serverCallId, String recordingId, Context context) {
        return (Response)this.pauseRecordingWithResponseAsync(serverCallId, recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String serverCallId, String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resumeRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String serverCallId, String recordingId, Context context) {
        String accept = "application/json";
        return this.service.resumeRecording(this.client.getEndpoint(), serverCallId, recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String serverCallId, String recordingId) {
        return this.resumeRecordingWithResponseAsync(serverCallId, recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String serverCallId, String recordingId, Context context) {
        return this.resumeRecordingWithResponseAsync(serverCallId, recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resumeRecording(String serverCallId, String recordingId) {
        this.resumeRecordingAsync(serverCallId, recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeRecordingWithResponse(String serverCallId, String recordingId, Context context) {
        return (Response)this.resumeRecordingWithResponseAsync(serverCallId, recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<JoinCallResultInternal>> joinCallWithResponseAsync(String serverCallId, JoinCallRequest callRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.joinCall(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), callRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<JoinCallResultInternal>> joinCallWithResponseAsync(String serverCallId, JoinCallRequest callRequest, Context context) {
        String accept = "application/json";
        return this.service.joinCall(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), callRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JoinCallResultInternal> joinCallAsync(String serverCallId, JoinCallRequest callRequest) {
        return this.joinCallWithResponseAsync(serverCallId, callRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((JoinCallResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JoinCallResultInternal> joinCallAsync(String serverCallId, JoinCallRequest callRequest, Context context) {
        return this.joinCallWithResponseAsync(serverCallId, callRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((JoinCallResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public JoinCallResultInternal joinCall(String serverCallId, JoinCallRequest callRequest) {
        return (JoinCallResultInternal)this.joinCallAsync(serverCallId, callRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JoinCallResultInternal> joinCallWithResponse(String serverCallId, JoinCallRequest callRequest, Context context) {
        return (Response)this.joinCallWithResponseAsync(serverCallId, callRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResultInternal>> playAudioWithResponseAsync(String serverCallId, PlayAudioRequest request) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.playAudio(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResultInternal>> playAudioWithResponseAsync(String serverCallId, PlayAudioRequest request, Context context) {
        String accept = "application/json";
        return this.service.playAudio(this.client.getEndpoint(), serverCallId, this.client.getApiVersion(), request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResultInternal> playAudioAsync(String serverCallId, PlayAudioRequest request) {
        return this.playAudioWithResponseAsync(serverCallId, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PlayAudioResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResultInternal> playAudioAsync(String serverCallId, PlayAudioRequest request, Context context) {
        return this.playAudioWithResponseAsync(serverCallId, request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PlayAudioResultInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResultInternal playAudio(String serverCallId, PlayAudioRequest request) {
        return (PlayAudioResultInternal)this.playAudioAsync(serverCallId, request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PlayAudioResultInternal> playAudioWithResponse(String serverCallId, PlayAudioRequest request, Context context) {
        return (Response)this.playAudioWithResponseAsync(serverCallId, request, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    private static interface ServerCallsService {
        @Post(value="/calling/serverCalls/{serverCallId}/participants")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<AddParticipantResultInternal>> addParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AddParticipantRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/calling/serverCalls/{serverCallId}/participants/{participantId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> removeParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @PathParam(value="participantId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/serverCalls/{serverCallId}/recordings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<StartCallRecordingResultInternal>> startRecording(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") StartCallRecordingRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/calling/serverCalls/{serverCallId}/recordings/{recordingId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallRecordingPropertiesInternal>> getRecordingProperties(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @PathParam(value="recordingId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/calling/serverCalls/{serverCallId}/recordings/{recordingId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> stopRecording(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @PathParam(value="recordingId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/serverCalls/{serverCallId}/recordings/{recordingId}/:pause")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> pauseRecording(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @PathParam(value="recordingId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/serverCalls/{serverCallId}/recordings/{recordingId}/:resume")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> resumeRecording(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @PathParam(value="recordingId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/serverCalls/{serverCallId}/:join")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<JoinCallResultInternal>> joinCall(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") JoinCallRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/serverCalls/{serverCallId}/:playAudio")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PlayAudioResultInternal>> playAudio(@HostParam(value="endpoint") String var1, @PathParam(value="serverCallId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PlayAudioRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

