/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.implementation.converters;

import com.azure.communication.callingserver.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callingserver.implementation.models.CreateCallRequest;
import com.azure.communication.callingserver.implementation.models.PhoneNumberIdentifierModel;
import com.azure.communication.callingserver.models.CreateCallOptions;
import com.azure.communication.callingserver.models.EventSubscriptionType;
import com.azure.communication.callingserver.models.MediaType;
import com.azure.communication.common.CommunicationIdentifier;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class CallConnectionRequestConverter {
    /*
     * WARNING - void declaration
     */
    public static CreateCallRequest convert(CommunicationIdentifier source, List<CommunicationIdentifier> targets, CreateCallOptions createCallOptions) {
        void var6_10;
        if (source == null || targets == null || targets.size() == 0) {
            return null;
        }
        CreateCallRequest createCallRequest = new CreateCallRequest().setSource(CommunicationIdentifierConverter.convert(source)).setTargets(targets.stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList()));
        if (createCallOptions == null) {
            return createCallRequest;
        }
        LinkedList<MediaType> requestedMediaTypes = new LinkedList<MediaType>();
        for (MediaType mediaType : createCallOptions.getRequestedMediaTypes()) {
            requestedMediaTypes.add(MediaType.fromString(mediaType.toString()));
        }
        LinkedList<EventSubscriptionType> requestedCallEvents = new LinkedList<EventSubscriptionType>();
        for (EventSubscriptionType requestedCallEvent : createCallOptions.getRequestedCallEvents()) {
            requestedCallEvents.add(EventSubscriptionType.fromString(requestedCallEvent.toString()));
        }
        Object var6_8 = null;
        if (createCallOptions.getAlternateCallerId() != null) {
            PhoneNumberIdentifierModel phoneNumberIdentifierModel = new PhoneNumberIdentifierModel().setValue(createCallOptions.getAlternateCallerId().getPhoneNumber());
        }
        return createCallRequest.setRequestedMediaTypes(requestedMediaTypes).setRequestedCallEvents(requestedCallEvents).setAlternateCallerId((PhoneNumberIdentifierModel)var6_10).setCallbackUri(createCallOptions.getCallbackUri());
    }
}

