/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.implementation.converters;

import com.azure.communication.callingserver.implementation.models.CommunicationError;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.models.CallingServerError;
import com.azure.communication.callingserver.models.CallingServerErrorException;
import java.util.ArrayList;
import java.util.stream.Collectors;

public final class CallingServerErrorConverter {
    public static CallingServerError convert(CommunicationError communicationError) {
        if (communicationError == null) {
            return null;
        }
        ArrayList<CallingServerError> details = new ArrayList();
        if (communicationError.getDetails() != null) {
            details = communicationError.getDetails().stream().map(CallingServerErrorConverter::convert).collect(Collectors.toList());
        }
        return new CallingServerError(communicationError.getMessage(), communicationError.getCode(), communicationError.getTarget(), details, CallingServerErrorConverter.convert(communicationError.getInnerError()));
    }

    public static CallingServerErrorException translateException(CommunicationErrorResponseException exception) {
        CallingServerError error = null;
        if (exception.getValue() != null) {
            error = CallingServerErrorConverter.convert(exception.getValue().getError());
        }
        return new CallingServerErrorException(exception.getMessage(), exception.getResponse(), error);
    }

    private CallingServerErrorConverter() {
    }
}

