/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.implementation.converters;

import com.azure.communication.callingserver.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callingserver.implementation.models.JoinCallRequest;
import com.azure.communication.callingserver.models.EventSubscriptionType;
import com.azure.communication.callingserver.models.JoinCallOptions;
import com.azure.communication.callingserver.models.MediaType;
import com.azure.communication.common.CommunicationIdentifier;
import java.util.ArrayList;

public final class JoinCallRequestConverter {
    public static JoinCallRequest convert(CommunicationIdentifier source, JoinCallOptions joinCallOptions) {
        if (source == null) {
            return null;
        }
        JoinCallRequest joinCallRequest = new JoinCallRequest().setSource(CommunicationIdentifierConverter.convert(source));
        if (joinCallOptions == null) {
            return joinCallRequest;
        }
        joinCallRequest.setSubject(joinCallOptions.getSubject());
        joinCallRequest.setCallbackUri(joinCallOptions.getCallbackUri());
        joinCallRequest.setRequestedMediaTypes(new ArrayList<MediaType>(joinCallOptions.getRequestedMediaTypes()));
        joinCallRequest.setRequestedCallEvents(new ArrayList<EventSubscriptionType>(joinCallOptions.getRequestedCallEvents()));
        return joinCallRequest;
    }

    private JoinCallRequestConverter() {
    }
}

