/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.models;

import com.azure.communication.callingserver.models.ProgressReceiver;
import java.util.Locale;

public final class ParallelDownloadOptions {
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private Long blockSize;
    private Integer maxConcurrency;
    private ProgressReceiver progressReceiver;

    public long getBlockSize() {
        return this.blockSize == null ? 0x400000L : this.blockSize;
    }

    public ParallelDownloadOptions setBlockSize(Long blockSize) {
        if (blockSize != null) {
            ParallelDownloadOptions.assertInBounds("blockSize", blockSize, 1L, Long.MAX_VALUE);
        }
        this.blockSize = blockSize;
        return this;
    }

    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    public ParallelDownloadOptions setProgressReceiver(ProgressReceiver progressReceiver) {
        this.progressReceiver = progressReceiver;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency == null ? 5 : this.maxConcurrency;
    }

    public ParallelDownloadOptions setMaxConcurrency(Integer maxConcurrency) {
        if (maxConcurrency != null) {
            ParallelDownloadOptions.assertInBounds("numBuffers", maxConcurrency.intValue(), 1L, Integer.MAX_VALUE);
        }
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, param, min, max));
        }
    }
}

