/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.models.events;

import com.azure.communication.callingserver.implementation.models.CallConnectionStateChangedEventInternal;
import com.azure.communication.callingserver.models.CallConnectionState;
import com.azure.communication.callingserver.models.events.CallingServerEventBase;
import com.azure.core.util.BinaryData;

public final class CallConnectionStateChangedEvent
extends CallingServerEventBase {
    private final String serverCallId;
    private final String callConnectionId;
    private final CallConnectionState callConnectionState;

    public String getServerCallId() {
        return this.serverCallId;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public CallConnectionState getCallConnectionState() {
        return this.callConnectionState;
    }

    CallConnectionStateChangedEvent(String serverCallId, String callConnectionId, CallConnectionState callConnectionState) {
        this.serverCallId = serverCallId;
        this.callConnectionId = callConnectionId;
        this.callConnectionState = callConnectionState;
    }

    public static CallConnectionStateChangedEvent deserialize(BinaryData eventData) {
        if (eventData == null) {
            return null;
        }
        CallConnectionStateChangedEventInternal callConnectionStateChangedEventInternal = (CallConnectionStateChangedEventInternal)eventData.toObject(CallConnectionStateChangedEventInternal.class);
        return new CallConnectionStateChangedEvent(callConnectionStateChangedEventInternal.getServerCallId(), callConnectionStateChangedEventInternal.getCallConnectionId(), callConnectionStateChangedEventInternal.getCallConnectionState());
    }
}

