/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.models.events;

import com.azure.communication.callingserver.implementation.models.CallRecordingStateChangeEventInternal;
import com.azure.communication.callingserver.models.CallRecordingState;
import com.azure.communication.callingserver.models.events.CallingServerEventBase;
import com.azure.core.util.BinaryData;
import java.time.OffsetDateTime;

public final class CallRecordingStateChangeEvent
extends CallingServerEventBase {
    private final String recordingId;
    private final CallRecordingState state;
    private final OffsetDateTime startDateTime;
    private final String serverCallId;

    public String getRecordingId() {
        return this.recordingId;
    }

    public CallRecordingState getState() {
        return this.state;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    CallRecordingStateChangeEvent(String recordingId, CallRecordingState state, OffsetDateTime startDateTime, String serverCallId) {
        this.recordingId = recordingId;
        this.state = state;
        this.startDateTime = startDateTime;
        this.serverCallId = serverCallId;
    }

    public static CallRecordingStateChangeEvent deserialize(BinaryData eventData) {
        if (eventData == null) {
            return null;
        }
        CallRecordingStateChangeEventInternal callRecordingStateChangeEventInternal = (CallRecordingStateChangeEventInternal)eventData.toObject(CallRecordingStateChangeEventInternal.class);
        return new CallRecordingStateChangeEvent(callRecordingStateChangeEventInternal.getRecordingId(), callRecordingStateChangeEventInternal.getState(), callRecordingStateChangeEventInternal.getStartDateTime(), callRecordingStateChangeEventInternal.getServerCallId());
    }
}

