/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.models.events;

import com.azure.communication.callingserver.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callingserver.implementation.models.CallParticipantInternal;
import com.azure.communication.callingserver.implementation.models.ParticipantsUpdatedEventInternal;
import com.azure.communication.callingserver.models.CallParticipant;
import com.azure.communication.callingserver.models.events.CallingServerEventBase;
import com.azure.core.util.BinaryData;
import java.util.LinkedList;
import java.util.List;

public final class ParticipantsUpdatedEvent
extends CallingServerEventBase {
    private final String callConnectionId;
    private final List<CallParticipant> participants;

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public List<CallParticipant> getParticipants() {
        return this.participants;
    }

    ParticipantsUpdatedEvent(String callConnectionId, List<CallParticipant> participants) {
        if (callConnectionId == null || callConnectionId.isEmpty()) {
            throw new IllegalArgumentException("object callConnectionId cannot be null or empty");
        }
        if (participants == null) {
            throw new IllegalArgumentException("object participants cannot be null");
        }
        this.callConnectionId = callConnectionId;
        this.participants = participants;
    }

    public static ParticipantsUpdatedEvent deserialize(BinaryData eventData) {
        if (eventData == null) {
            return null;
        }
        ParticipantsUpdatedEventInternal internalEvent = (ParticipantsUpdatedEventInternal)eventData.toObject(ParticipantsUpdatedEventInternal.class);
        LinkedList<CallParticipant> participants = new LinkedList<CallParticipant>();
        for (CallParticipantInternal callParticipantInternal : internalEvent.getParticipants()) {
            participants.add(new CallParticipant(CommunicationIdentifierConverter.convert(callParticipantInternal.getIdentifier()), callParticipantInternal.getParticipantId(), callParticipantInternal.isMuted()));
        }
        return new ParticipantsUpdatedEvent(internalEvent.getCallConnectionId(), participants);
    }
}

