/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver.models.events;

import com.azure.communication.callingserver.implementation.models.ToneReceivedEventInternal;
import com.azure.communication.callingserver.models.ToneInfo;
import com.azure.communication.callingserver.models.events.CallingServerEventBase;
import com.azure.core.util.BinaryData;

public final class ToneReceivedEvent
extends CallingServerEventBase {
    private final ToneInfo toneInfo;
    private final String callConnectionId;

    public ToneInfo getToneInfo() {
        return this.toneInfo;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    ToneReceivedEvent(ToneInfo toneInfo, String callConnectionId) {
        this.toneInfo = toneInfo;
        this.callConnectionId = callConnectionId;
    }

    public static ToneReceivedEvent deserialize(BinaryData eventData) {
        if (eventData == null) {
            return null;
        }
        ToneReceivedEventInternal toneReceivedEventInternal = (ToneReceivedEventInternal)eventData.toObject(ToneReceivedEventInternal.class);
        return new ToneReceivedEvent(new ToneInfo(toneReceivedEventInternal.getToneInfo().getSequenceId(), toneReceivedEventInternal.getToneInfo().getTone()), toneReceivedEventInternal.getCallConnectionId());
    }
}

