// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A chat message read receipt indicates the time a chat message was read by a recipient. */
@Fluent
public final class ChatMessageReadReceipt {
    /*
     * Identifies a participant in Azure Communication services. A participant
     * is, for example, a phone number or an Azure communication user. This
     * model must be interpreted as a union: Apart from rawId, at most one
     * further property may be set.
     */
    @JsonProperty(value = "senderCommunicationIdentifier", required = true)
    private CommunicationIdentifierModel senderCommunicationIdentifier;

    /*
     * Id of the chat message that has been read. This id is generated by the
     * server.
     */
    @JsonProperty(value = "chatMessageId", required = true)
    private String chatMessageId;

    /*
     * The time at which the message was read. The timestamp is in RFC3339
     * format: `yyyy-MM-ddTHH:mm:ssZ`.
     */
    @JsonProperty(value = "readOn", required = true)
    private OffsetDateTime readOn;

    /**
     * Get the senderCommunicationIdentifier property: Identifies a participant in Azure Communication services. A
     * participant is, for example, a phone number or an Azure communication user. This model must be interpreted as a
     * union: Apart from rawId, at most one further property may be set.
     *
     * @return the senderCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getSenderCommunicationIdentifier() {
        return this.senderCommunicationIdentifier;
    }

    /**
     * Set the senderCommunicationIdentifier property: Identifies a participant in Azure Communication services. A
     * participant is, for example, a phone number or an Azure communication user. This model must be interpreted as a
     * union: Apart from rawId, at most one further property may be set.
     *
     * @param senderCommunicationIdentifier the senderCommunicationIdentifier value to set.
     * @return the ChatMessageReadReceipt object itself.
     */
    public ChatMessageReadReceipt setSenderCommunicationIdentifier(
            CommunicationIdentifierModel senderCommunicationIdentifier) {
        this.senderCommunicationIdentifier = senderCommunicationIdentifier;
        return this;
    }

    /**
     * Get the chatMessageId property: Id of the chat message that has been read. This id is generated by the server.
     *
     * @return the chatMessageId value.
     */
    public String getChatMessageId() {
        return this.chatMessageId;
    }

    /**
     * Set the chatMessageId property: Id of the chat message that has been read. This id is generated by the server.
     *
     * @param chatMessageId the chatMessageId value to set.
     * @return the ChatMessageReadReceipt object itself.
     */
    public ChatMessageReadReceipt setChatMessageId(String chatMessageId) {
        this.chatMessageId = chatMessageId;
        return this;
    }

    /**
     * Get the readOn property: The time at which the message was read. The timestamp is in RFC3339 format:
     * `yyyy-MM-ddTHH:mm:ssZ`.
     *
     * @return the readOn value.
     */
    public OffsetDateTime getReadOn() {
        return this.readOn;
    }

    /**
     * Set the readOn property: The time at which the message was read. The timestamp is in RFC3339 format:
     * `yyyy-MM-ddTHH:mm:ssZ`.
     *
     * @param readOn the readOn value to set.
     * @return the ChatMessageReadReceipt object itself.
     */
    public ChatMessageReadReceipt setReadOn(OffsetDateTime readOn) {
        this.readOn = readOn;
        return this;
    }
}
