// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Collection of chat messages for a particular chat thread. */
@Fluent
public final class ChatMessagesCollection {
    /*
     * Collection of chat messages.
     */
    @JsonProperty(value = "value", required = true)
    private List<ChatMessage> value;

    /*
     * If there are more chat messages that can be retrieved, the next link
     * will be populated.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: Collection of chat messages.
     *
     * @return the value value.
     */
    public List<ChatMessage> getValue() {
        return this.value;
    }

    /**
     * Set the value property: Collection of chat messages.
     *
     * @param value the value value to set.
     * @return the ChatMessagesCollection object itself.
     */
    public ChatMessagesCollection setValue(List<ChatMessage> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: If there are more chat messages that can be retrieved, the next link will be
     * populated.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
