// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.models.ChatThreadItem;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Collection of chat threads. */
@Fluent
public final class ChatThreadsItemCollection {
    /*
     * Collection of chat threads.
     */
    @JsonProperty(value = "value", required = true)
    private List<ChatThreadItem> value;

    /*
     * If there are more chat threads that can be retrieved, the next link will
     * be populated.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: Collection of chat threads.
     *
     * @return the value value.
     */
    public List<ChatThreadItem> getValue() {
        return this.value;
    }

    /**
     * Set the value property: Collection of chat threads.
     *
     * @param value the value value to set.
     * @return the ChatThreadsItemCollection object itself.
     */
    public ChatThreadsItemCollection setValue(List<ChatThreadItem> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: If there are more chat threads that can be retrieved, the next link will be populated.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
