// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The IndividualStatusResponse model. */
@Immutable
public final class IndividualStatusResponse {
    /*
     * Identifies the resource to which the individual status corresponds.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The status code of the resource operation.
     *
     * Possible values include:
     * 200 for a successful update or delete,
     * 201 for successful creation,
     * 400 for a malformed input,
     * 403 for lacking permission to execute the operation,
     * 404 for resource not found.
     */
    @JsonProperty(value = "statusCode", access = JsonProperty.Access.WRITE_ONLY)
    private Integer statusCode;

    /*
     * The message explaining why the operation failed for the resource
     * identified by the key; null if the operation succeeded.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /*
     * Identifies the type of the resource to which the individual status
     * corresponds.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the id property: Identifies the resource to which the individual status corresponds.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the statusCode property: The status code of the resource operation.
     *
     * <p>Possible values include: 200 for a successful update or delete, 201 for successful creation, 400 for a
     * malformed input, 403 for lacking permission to execute the operation, 404 for resource not found.
     *
     * @return the statusCode value.
     */
    public Integer getStatusCode() {
        return this.statusCode;
    }

    /**
     * Get the message property: The message explaining why the operation failed for the resource identified by the key;
     * null if the operation succeeded.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the type property: Identifies the type of the resource to which the individual status corresponds.
     *
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }
}
