// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Request payload for sending a read receipt. */
@Fluent
public final class SendReadReceiptRequest {
    /*
     * Id of the latest chat message read by the user.
     */
    @JsonProperty(value = "chatMessageId", required = true)
    private String chatMessageId;

    /**
     * Get the chatMessageId property: Id of the latest chat message read by the user.
     *
     * @return the chatMessageId value.
     */
    public String getChatMessageId() {
        return this.chatMessageId;
    }

    /**
     * Set the chatMessageId property: Id of the latest chat message read by the user.
     *
     * @param chatMessageId the chatMessageId value to set.
     * @return the SendReadReceiptRequest object itself.
     */
    public SendReadReceiptRequest setChatMessageId(String chatMessageId) {
        this.chatMessageId = chatMessageId;
        return this;
    }
}
