// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of the add chat participants operation. */
@Immutable
public final class AddChatParticipantsResult {
    /*
     * The participants that failed to be added to the chat thread.
     */
    @JsonProperty(value = "invalidParticipants", access = JsonProperty.Access.WRITE_ONLY)
    private List<ChatError> invalidParticipants;

    /**
     *
     * @param invalidParticipants List of errors relating to invalid participants
     */
    public AddChatParticipantsResult(List<ChatError> invalidParticipants) {
        this.invalidParticipants = invalidParticipants;
    }

    /**
     * Get the invalidParticipants property: The participants that failed to be added to the chat thread.
     * The 'target' property of each ChatError will reference the failed participant.
     *
     * @return the invalidParticipants value.
     */
    public List<ChatError> getInvalidParticipants() {
        return this.invalidParticipants;
    }
}
