// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.chat.models;

import com.azure.core.annotation.Fluent;
import java.time.OffsetDateTime;

/**
 * Additional parameters for chat threads operation.
 */
@Fluent
public final class ListChatThreadsOptions {
    private Integer maxPageSize;
    private OffsetDateTime startTime;

    /**
     * Gets the maximum page size. It represents the number of threads being requested.
     *
     * @return The maximum page size.
     */
    public Integer getMaxPageSize() {
        return maxPageSize;
    }

    /**
     * Set the page size. It represents the number of threads being requested.
     *
     * @param maxPageSize The maximum page size.
     * @return The {@link ListChatThreadsOptions} object itself.
     */
    public ListChatThreadsOptions setMaxPageSize(Integer maxPageSize) {
        this.maxPageSize = maxPageSize;
        return this;
    }

    /**
     * Gets the start time for the range to query.
     *
     * @return The start time.
     */
    public OffsetDateTime getStartTime() {
        return startTime;
    }

    /**
     * Sets the start time for the range to query.
     *
     * @param startTime The start time.
     * @return The {@link ListChatThreadsOptions} object itself.
     */
    public ListChatThreadsOptions setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }
}
