/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationTokenRefreshOptions;
import com.azure.communication.common.implementation.TokenParser;
import com.azure.core.credential.AccessToken;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public final class CommunicationTokenCredential
implements AutoCloseable {
    private static final int DEFAULT_EXPIRING_OFFSET_MINUTES = 10;
    private final ClientLogger logger = new ClientLogger(CommunicationTokenCredential.class);
    private AccessToken accessToken;
    private final TokenParser tokenParser = new TokenParser();
    private Supplier<Mono<String>> refresher;
    private FetchingTask fetchingTask;
    private boolean isClosed = false;

    public CommunicationTokenCredential(String token) {
        Objects.requireNonNull(token, "'token' cannot be null.");
        this.setToken(token);
    }

    public CommunicationTokenCredential(CommunicationTokenRefreshOptions tokenRefreshOptions) {
        Supplier<Mono<String>> tokenRefresher = tokenRefreshOptions.getTokenRefresher();
        Objects.requireNonNull(tokenRefresher, "'tokenRefresher' cannot be null.");
        this.refresher = tokenRefresher;
        if (tokenRefreshOptions.getInitialToken() != null) {
            this.setToken(tokenRefreshOptions.getInitialToken());
            if (tokenRefreshOptions.isRefreshProactively()) {
                OffsetDateTime nextFetchTime = this.accessToken.getExpiresAt().minusMinutes(10L);
                this.fetchingTask = new FetchingTask(this, nextFetchTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<AccessToken> getToken() {
        if (this.isClosed) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("getToken called on closed CommunicationTokenCredential object"));
        }
        if ((this.accessToken == null || this.accessToken.isExpired()) && this.refresher != null) {
            CommunicationTokenCredential communicationTokenCredential = this;
            synchronized (communicationTokenCredential) {
                if ((this.accessToken == null || this.accessToken.isExpired()) && this.refresher != null) {
                    return this.fetchFreshToken().map(token -> {
                        this.accessToken = this.tokenParser.parseJWTToken((String)token);
                        return this.accessToken;
                    });
                }
            }
        }
        return Mono.just((Object)this.accessToken);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.fetchingTask != null) {
            this.fetchingTask.stopTimer();
            this.fetchingTask = null;
        }
        this.refresher = null;
    }

    boolean hasProactiveFetcher() {
        return this.fetchingTask != null;
    }

    private void setToken(String freshToken) {
        this.accessToken = this.tokenParser.parseJWTToken(freshToken);
        if (this.fetchingTask != null) {
            OffsetDateTime nextFetchTime = this.accessToken.getExpiresAt().minusMinutes(10L);
            this.fetchingTask.setNextFetchTime(nextFetchTime);
        }
    }

    private Mono<String> fetchFreshToken() {
        Mono<String> tokenAsync = this.refresher.get();
        if (tokenAsync == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("get() function of the token refresher should not return null."));
        }
        return tokenAsync;
    }

    private static class FetchingTask {
        private final CommunicationTokenCredential host;
        private Timer expiringTimer;
        private OffsetDateTime nextFetchTime;

        FetchingTask(CommunicationTokenCredential tokenHost, OffsetDateTime nextFetchAt) {
            this.host = tokenHost;
            this.nextFetchTime = nextFetchAt;
            this.startTimer();
        }

        private synchronized void setNextFetchTime(OffsetDateTime newFetchTime) {
            this.nextFetchTime = newFetchTime;
            this.stopTimer();
            this.startTimer();
        }

        private synchronized void startTimer() {
            this.expiringTimer = new Timer();
            Date expiring = Date.from(this.nextFetchTime.toInstant());
            this.expiringTimer.schedule((TimerTask)new TokenExpiringTask(this), expiring);
        }

        private synchronized void stopTimer() {
            if (this.expiringTimer == null) {
                return;
            }
            this.expiringTimer.cancel();
            this.expiringTimer.purge();
            this.expiringTimer = null;
        }

        private Mono<String> fetchFreshToken() {
            return this.host.fetchFreshToken();
        }

        private void setToken(String freshTokenString) {
            this.host.setToken(freshTokenString);
        }

        private class TokenExpiringTask
        extends TimerTask {
            private final ClientLogger logger = new ClientLogger(TokenExpiringTask.class);
            private final FetchingTask tokenCache;

            TokenExpiringTask(FetchingTask host) {
                this.tokenCache = host;
            }

            @Override
            public void run() {
                try {
                    Mono tokenAsync = this.tokenCache.fetchFreshToken();
                    this.tokenCache.setToken((String)tokenAsync.block());
                }
                catch (Exception exception) {
                    this.logger.logExceptionAsError(new RuntimeException(exception));
                }
            }
        }
    }
}

