/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationCloudEnvironment;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;

public final class MicrosoftTeamsUserIdentifier
extends CommunicationIdentifier {
    private final String userId;
    private final boolean isAnonymous;
    private CommunicationCloudEnvironment cloudEnvironment = CommunicationCloudEnvironment.PUBLIC;
    private String rawId;

    public MicrosoftTeamsUserIdentifier(String userId, boolean isAnonymous) {
        if (CoreUtils.isNullOrEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("The initialization parameter [userId] cannot be null or empty.");
        }
        this.userId = userId;
        this.isAnonymous = isAnonymous;
    }

    public MicrosoftTeamsUserIdentifier(String userId) {
        this(userId, false);
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public MicrosoftTeamsUserIdentifier setCloudEnvironment(CommunicationCloudEnvironment cloudEnvironment) {
        this.cloudEnvironment = cloudEnvironment;
        return this;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    public String getRawId() {
        return this.rawId;
    }

    public MicrosoftTeamsUserIdentifier setRawId(String rawId) {
        this.rawId = rawId;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MicrosoftTeamsUserIdentifier)) {
            return false;
        }
        MicrosoftTeamsUserIdentifier thatId = (MicrosoftTeamsUserIdentifier)that;
        if (!thatId.getUserId().equals(this.getUserId()) || thatId.isAnonymous != this.isAnonymous) {
            return false;
        }
        if (this.cloudEnvironment != null && !this.cloudEnvironment.equals((Object)thatId.cloudEnvironment)) {
            return false;
        }
        if (thatId.cloudEnvironment != null && !thatId.cloudEnvironment.equals((Object)this.cloudEnvironment)) {
            return false;
        }
        return this.getRawId() == null || thatId.getRawId() == null || thatId.getRawId().equals(this.getRawId());
    }

    public int hashCode() {
        return this.userId.hashCode();
    }
}

