/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;

public final class PhoneNumberIdentifier
extends CommunicationIdentifier {
    private final String phoneNumber;

    public PhoneNumberIdentifier(String phoneNumber) {
        if (CoreUtils.isNullOrEmpty((CharSequence)phoneNumber)) {
            throw new IllegalArgumentException("The initialization parameter [phoneNumber] cannot be null to empty.");
        }
        this.phoneNumber = phoneNumber;
        this.setRawId("4:" + phoneNumber.replaceAll("^[+]", ""));
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public PhoneNumberIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PhoneNumberIdentifier)) {
            return false;
        }
        PhoneNumberIdentifier phoneId = (PhoneNumberIdentifier)that;
        return this.getRawId() == null || phoneId.getRawId() == null || this.getRawId().equals(phoneId.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

