/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class HmacAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String X_MS_DATE_HEADER = "x-ms-date";
    private static final String X_MS_STRING_TO_SIGN_HEADER = "x-ms-hmac-string-to-sign-base64";
    private static final String HOST_HEADER = "host";
    private static final String CONTENT_HASH_HEADER = "x-ms-content-sha256";
    private static final String[] SIGNED_HEADERS = new String[]{"x-ms-date", "host", "x-ms-content-sha256"};
    private static final String AUTHORIZATIONHEADERNAME = "Authorization";
    private static final String HMACSHA256FORMAT = "HMAC-SHA256 SignedHeaders=%s&Signature=%s";
    static final DateTimeFormatter HMAC_DATETIMEFORMATTER_PATTERN = DateTimeFormatter.ofPattern("E, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private final AzureKeyCredential credential;
    private final ClientLogger logger = new ClientLogger(HmacAuthenticationPolicy.class);

    public HmacAuthenticationPolicy(AzureKeyCredential clientCredential) {
        Objects.requireNonNull(clientCredential, "'clientCredential' cannot be a null value.");
        this.credential = clientCredential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Flux contents;
        Flux flux = contents = context.getHttpRequest().getBody() == null ? Flux.just((Object)ByteBuffer.allocate(0)) : context.getHttpRequest().getBody();
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("AzureKeyCredential requires a URL using the HTTPS protocol scheme"));
        }
        try {
            URL hostnameToSignWith = context.getData("hmacSignatureURL").filter(alternativeUrl -> alternativeUrl instanceof URL).map(alternativeUrl -> (URL)alternativeUrl).orElse(context.getHttpRequest().getUrl());
            return this.appendAuthorizationHeaders(hostnameToSignWith, context.getHttpRequest().getHttpMethod().toString(), (Flux<ByteBuffer>)contents).flatMap(headers -> {
                headers.entrySet().forEach(header -> context.getHttpRequest().setHeader((String)header.getKey(), (String)header.getValue()));
                return next.process();
            });
        }
        catch (RuntimeException r) {
            return Mono.error((Throwable)r);
        }
    }

    private Mono<Map<String, String>> appendAuthorizationHeaders(URL url, String httpMethod, Flux<ByteBuffer> contents) {
        return contents.collect(() -> {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
        }, MessageDigest::update).map(messageDigest -> this.addAuthenticationHeaders(url, httpMethod, (MessageDigest)messageDigest));
    }

    private Map<String, String> addAuthenticationHeaders(URL url, String httpMethod, MessageDigest messageDigest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String contentHash = Base64.getEncoder().encodeToString(messageDigest.digest());
        headers.put(CONTENT_HASH_HEADER, contentHash);
        String utcNow = OffsetDateTime.now(ZoneOffset.UTC).format(HMAC_DATETIMEFORMATTER_PATTERN);
        headers.put(X_MS_DATE_HEADER, utcNow);
        headers.put(HOST_HEADER, url.getHost());
        this.addSignatureHeader(url, httpMethod, headers);
        return headers;
    }

    private void addSignatureHeader(URL url, String httpMethod, Map<String, String> httpHeaders) {
        Mac sha256HMAC;
        String signedHeaderNames = String.join((CharSequence)";", SIGNED_HEADERS);
        String signedHeaderValues = Arrays.stream(SIGNED_HEADERS).map(httpHeaders::get).collect(Collectors.joining(";"));
        String pathAndQuery = url.getPath();
        if (url.getQuery() != null) {
            pathAndQuery = pathAndQuery + '?' + url.getQuery();
        }
        String stringToSign = httpMethod.toUpperCase(Locale.US) + "\n" + pathAndQuery + "\n" + signedHeaderValues;
        String accessKey = this.credential.getKey();
        byte[] key = Base64.getDecoder().decode(accessKey);
        try {
            sha256HMAC = Mac.getInstance("HmacSHA256");
            sha256HMAC.init(new SecretKeySpec(key, "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        String signature = Base64.getEncoder().encodeToString(sha256HMAC.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
        httpHeaders.put(AUTHORIZATIONHEADERNAME, String.format(HMACSHA256FORMAT, signedHeaderNames, signature));
        httpHeaders.put(X_MS_STRING_TO_SIGN_HEADER, Base64.getEncoder().encodeToString(stringToSign.getBytes(StandardCharsets.UTF_8)));
    }
}

