/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common.implementation;

import java.util.Objects;

public class CommunicationConnectionString {
    private static final String TOKEN_VALUE_SEPARATOR = "=";
    private static final String TOKEN_VALUE_PAIR_DELIMITER = ";";
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String ACCESS_KEY_NAME = "accessKey";
    private final String endpoint;
    private final String accessKey;

    public CommunicationConnectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        if (connectionString.isEmpty()) {
            throw new IllegalArgumentException("'connectionString' cannot be an empty string.");
        }
        String[] tokenValuePairs = connectionString.split(TOKEN_VALUE_PAIR_DELIMITER);
        String endpoint = null;
        String accessKey = null;
        for (String tokenValuePair : tokenValuePairs) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException(String.format("Connection string has invalid key value pair: %s", tokenValuePair));
            }
            String key = pair[0].trim();
            String value = pair[1].trim();
            if (key.equalsIgnoreCase(ENDPOINT_NAME)) {
                endpoint = Objects.requireNonNull(value, "'endpoint' cannot be null.");
                continue;
            }
            if (key.equalsIgnoreCase(ACCESS_KEY_NAME)) {
                accessKey = Objects.requireNonNull(value, "'accessKey' cannot be null.");
                continue;
            }
            throw new IllegalArgumentException(String.format("Illegal connection string parameter name: %s", key));
        }
        this.endpoint = endpoint;
        this.accessKey = accessKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }
}

