/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.EntraCommunicationTokenUtils;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.CoreUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class EntraCommunicationTokenCredentialOptions {
    private final TokenCredential tokenCredential;
    private final String resourceEndpoint;
    private List<String> scopes;

    public EntraCommunicationTokenCredentialOptions(TokenCredential tokenCredential, String resourceEndpoint) {
        Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceEndpoint)) {
            throw new IllegalArgumentException("'resourceEndpoint' cannot be null or empty.");
        }
        this.resourceEndpoint = resourceEndpoint;
        this.tokenCredential = tokenCredential;
        this.scopes = new ArrayList<String>(){
            {
                this.add("https://communication.azure.com/clients/.default");
            }
        };
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public String getResourceEndpoint() {
        return this.resourceEndpoint;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public EntraCommunicationTokenCredentialOptions setScopes(List<String> scopes) {
        this.scopes = EntraCommunicationTokenCredentialOptions.validateScopes(scopes);
        return this;
    }

    private static List<String> validateScopes(List<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            throw new IllegalArgumentException("Scopes must not be null or empty. Ensure all scopes start with either https://auth.msft.communication.azure.com/ or https://communication.azure.com/clients/.");
        }
        if (EntraCommunicationTokenUtils.allScopesStartWith(scopes, "https://auth.msft.communication.azure.com/") || EntraCommunicationTokenUtils.allScopesStartWith(scopes, "https://communication.azure.com/clients/")) {
            return scopes;
        }
        throw new IllegalArgumentException("Scopes validation failed. Ensure all scopes start with either https://auth.msft.communication.azure.com/ or https://communication.azure.com/clients/.");
    }
}

