/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;

public final class PhoneNumberIdentifier
extends CommunicationIdentifier {
    private static final String ANONYMOUS = "anonymous";
    private final String phoneNumber;
    private String assertedId;
    private boolean isAnonymous;

    public PhoneNumberIdentifier(String phoneNumber) {
        if (CoreUtils.isNullOrEmpty((CharSequence)phoneNumber)) {
            throw new IllegalArgumentException("The initialization parameter [phoneNumber] cannot be null to empty.");
        }
        this.phoneNumber = phoneNumber;
        this.setRawId("4:" + phoneNumber);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public String getAssertedId() {
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.assertedId)) {
            return this.assertedId;
        }
        String[] segments = this.getRawId().substring("4:".length()).split("_");
        if (segments.length > 1) {
            this.assertedId = segments[segments.length - 1];
            return this.assertedId;
        }
        this.assertedId = "";
        return null;
    }

    @Override
    public PhoneNumberIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        this.isAnonymous = "4:anonymous".equals(rawId);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PhoneNumberIdentifier)) {
            return false;
        }
        PhoneNumberIdentifier phoneId = (PhoneNumberIdentifier)that;
        return this.getRawId() == null || phoneId.getRawId() == null || this.getRawId().equals(phoneId.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

