/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common.implementation;

import com.azure.communication.common.implementation.TokenParser;
import com.azure.core.credential.AccessToken;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class EntraTokenGuardPolicy
implements HttpPipelinePolicy {
    private String entraTokenCache;
    private HttpResponse responseCache;

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String currentEntraToken = context.getHttpRequest().getHeaders().get(HttpHeaderName.AUTHORIZATION).getValue();
        boolean entraTokenCacheValid = this.isEntraTokenCacheValid(currentEntraToken);
        if (entraTokenCacheValid && this.isAcsTokenCacheValid()) {
            return Mono.just((Object)this.responseCache);
        }
        this.entraTokenCache = currentEntraToken;
        return next.process().doOnNext(response -> {
            this.responseCache = response;
        });
    }

    private boolean isEntraTokenCacheValid(String currentEntraToken) {
        return !CoreUtils.isNullOrEmpty((CharSequence)this.entraTokenCache) && this.entraTokenCache.equals(currentEntraToken);
    }

    private boolean isAcsTokenCacheValid() {
        return this.responseCache != null && this.responseCache.getStatusCode() == 200 && this.isAcsTokenValid();
    }

    private boolean isAcsTokenValid() {
        try {
            String body = (String)this.responseCache.getBodyAsString(StandardCharsets.UTF_8).block();
            JsonNode root = new ObjectMapper().readTree(body);
            JsonNode accessTokenNode = root.get("accessToken");
            AccessToken accessToken = new TokenParser().parseJWTToken(accessTokenNode.get("token").asText());
            return OffsetDateTime.now().isBefore(accessToken.getExpiresAt());
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
    }
}

