/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationCloudEnvironment;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.common.MicrosoftBotIdentifier;
import com.azure.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.communication.common.PhoneNumberIdentifier;
import com.azure.communication.common.UnknownIdentifier;
import com.azure.core.util.CoreUtils;

public abstract class CommunicationIdentifier {
    static final String PHONE_NUMBER_PREFIX = "4:";
    static final String BOT_PREFIX = "28:";
    static final String BOT_PUBLIC_CLOUD_PREFIX = "28:orgid:";
    static final String BOT_DOD_CLOUD_PREFIX = "28:dod:";
    static final String BOT_DOD_CLOUD_GLOBAL_PREFIX = "28:dod-global:";
    static final String BOT_GCCH_CLOUD_PREFIX = "28:gcch:";
    static final String BOT_GCCH_CLOUD_GLOBAL_PREFIX = "28:gcch-global:";
    static final String TEAMS_USER_ANONYMOUS_PREFIX = "8:teamsvisitor:";
    static final String TEAMS_USER_PUBLIC_CLOUD_PREFIX = "8:orgid:";
    static final String TEAMS_USER_DOD_CLOUD_PREFIX = "8:dod:";
    static final String TEAMS_USER_GCCH_CLOUD_PREFIX = "8:gcch:";
    static final String ACS_USER_PREFIX = "8:acs:";
    static final String ACS_USER_DOD_CLOUD_PREFIX = "8:dod-acs:";
    static final String ACS_USER_GCCH_CLOUD_PREFIX = "8:gcch-acs:";
    static final String SPOOL_USER_PREFIX = "8:spool:";
    private String rawId;

    public static CommunicationIdentifier fromRawId(String rawId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)rawId)) {
            throw new IllegalArgumentException("The parameter [rawId] cannot be null to empty.");
        }
        if (rawId.startsWith(PHONE_NUMBER_PREFIX)) {
            return new PhoneNumberIdentifier(rawId.substring(PHONE_NUMBER_PREFIX.length()));
        }
        String[] segments = rawId.split(":");
        if (segments.length != 3) {
            if (segments.length == 2 && rawId.startsWith(BOT_PREFIX)) {
                return new MicrosoftBotIdentifier(segments[1], false, CommunicationCloudEnvironment.PUBLIC);
            }
            return new UnknownIdentifier(rawId);
        }
        String prefix = segments[0] + ":" + segments[1] + ":";
        String suffix = segments[2];
        if (TEAMS_USER_ANONYMOUS_PREFIX.equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, true);
        }
        if (TEAMS_USER_PUBLIC_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false);
        }
        if (TEAMS_USER_DOD_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.DOD);
        }
        if (TEAMS_USER_GCCH_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.GCCH);
        }
        if (ACS_USER_PREFIX.equals(prefix) || SPOOL_USER_PREFIX.equals(prefix) || ACS_USER_DOD_CLOUD_PREFIX.equals(prefix) || ACS_USER_GCCH_CLOUD_PREFIX.equals(prefix)) {
            return new CommunicationUserIdentifier(rawId);
        }
        if (BOT_GCCH_CLOUD_GLOBAL_PREFIX.equals(prefix)) {
            return new MicrosoftBotIdentifier(suffix, false, CommunicationCloudEnvironment.GCCH);
        }
        if (BOT_PUBLIC_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftBotIdentifier(suffix, true, CommunicationCloudEnvironment.PUBLIC);
        }
        if (BOT_DOD_CLOUD_GLOBAL_PREFIX.equals(prefix)) {
            return new MicrosoftBotIdentifier(suffix, false, CommunicationCloudEnvironment.DOD);
        }
        if (BOT_GCCH_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftBotIdentifier(suffix, true, CommunicationCloudEnvironment.GCCH);
        }
        if (BOT_DOD_CLOUD_PREFIX.equals(prefix)) {
            return new MicrosoftBotIdentifier(suffix, true, CommunicationCloudEnvironment.DOD);
        }
        return new UnknownIdentifier(rawId);
    }

    public String getRawId() {
        return this.rawId;
    }

    protected CommunicationIdentifier setRawId(String rawId) {
        this.rawId = rawId;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof CommunicationIdentifier)) {
            return false;
        }
        CommunicationIdentifier thatId = (CommunicationIdentifier)that;
        return this.getRawId().equals(thatId.getRawId());
    }

    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

