/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationCloudEnvironment;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;

public final class MicrosoftBotIdentifier
extends CommunicationIdentifier {
    private final String botId;
    private final boolean isResourceAccountConfigured;
    private boolean rawIdSet = false;
    private final CommunicationCloudEnvironment cloudEnvironment;

    public MicrosoftBotIdentifier(String botId, boolean isResourceAccountConfigured, CommunicationCloudEnvironment cloudEnvironment) {
        if (CoreUtils.isNullOrEmpty((CharSequence)botId)) {
            throw new IllegalArgumentException("The initialization parameter [botId] cannot be null or empty.");
        }
        this.botId = botId;
        this.cloudEnvironment = cloudEnvironment;
        this.isResourceAccountConfigured = isResourceAccountConfigured;
        this.generateRawId();
    }

    public MicrosoftBotIdentifier(String botId) {
        this(botId, true, CommunicationCloudEnvironment.PUBLIC);
    }

    public MicrosoftBotIdentifier(String botId, boolean isResourceAccountConfigured) {
        this(botId, isResourceAccountConfigured, CommunicationCloudEnvironment.PUBLIC);
    }

    public String getBotId() {
        return this.botId;
    }

    public boolean isResourceAccountConfigured() {
        return this.isResourceAccountConfigured;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    @Override
    public MicrosoftBotIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        this.rawIdSet = true;
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MicrosoftBotIdentifier)) {
            return false;
        }
        return ((MicrosoftBotIdentifier)that).getRawId().equals(this.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }

    private void generateRawId() {
        if (!this.rawIdSet) {
            if (!this.isResourceAccountConfigured) {
                if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
                    super.setRawId("28:dod-global:" + this.botId);
                } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
                    super.setRawId("28:gcch-global:" + this.botId);
                } else {
                    super.setRawId("28:" + this.botId);
                }
            } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
                super.setRawId("28:dod:" + this.botId);
            } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
                super.setRawId("28:gcch:" + this.botId);
            } else {
                super.setRawId("28:orgid:" + this.botId);
            }
        }
    }
}

