// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email;

import com.azure.communication.email.models.SendEmailResult;
import com.azure.communication.email.models.SendStatusResult;
import com.azure.communication.email.models.EmailMessage;
import com.azure.communication.email.implementation.EmailsImpl;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the asynchronous EmailAsyncClient type. */
@ServiceClient(builder = EmailClientBuilder.class, isAsync = true)
public final class EmailAsyncClient {
    private final EmailsImpl serviceClient;

    /**
     * Initializes an instance of EmailAsyncClient class.
     *
     * @param serviceClient the service client implementation.
     */
    EmailAsyncClient(EmailsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Gets the status of a message sent previously.
     * @param messageId System generated message id (GUID) returned from a previous call to send email.
     * @return the status of a message sent previously
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendStatusResult> getSendStatus(String messageId) {
        return this.serviceClient.getSendStatusWithResponseAsync(messageId, null)
                .flatMap((Response<BinaryData> response) -> {
                    return Mono.just(response.getValue().toObject(SendStatusResult.class));
                });
    }

    /**
     * Queues an email message to be sent to one or more recipients
     * @param emailMessage Message payload for sending an email.
     * @return the SendEmailResult
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendEmailResult> send(EmailMessage emailMessage) {
        return this.serviceClient.sendWithResponseAsync(BinaryData.fromObject(emailMessage), null)
                .flatMap((Response<Void> response) -> {
                    SendEmailResult result = new SendEmailResult()
                        .setMessageId(response.getHeaders().getValue("x-ms-request-id"));
                    return Mono.just(result);
                });
    }
}
