// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Emails. */
public final class EmailsImpl {
    /** The proxy service used to perform REST calls. */
    private final EmailsService service;

    /** The service client containing this operation class. */
    private final AzureCommunicationServicesClientImpl client;

    /**
     * Initializes an instance of EmailsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    EmailsImpl(AzureCommunicationServicesClientImpl client) {
        this.service = RestProxy.create(EmailsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureCommunicationServicesEmails to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureCommunicationSe")
    private interface EmailsService {
        @Get("/emails/{messageId}/status")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getSendStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam("messageId") String messageId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post("/emails:send")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> send(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BinaryData emailMessage,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);
    }

    /**
     * Gets the status of a message sent previously.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messageId: String
     *     status: String(queued/outForDelivery/dropped)
     * }
     * }</pre>
     *
     * @param messageId System generated message id (GUID) returned from a previous call to send email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a message sent previously along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSendStatusWithResponseAsync(String messageId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getSendStatus(
                                this.client.getEndpoint(),
                                messageId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the status of a message sent previously.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messageId: String
     *     status: String(queued/outForDelivery/dropped)
     * }
     * }</pre>
     *
     * @param messageId System generated message id (GUID) returned from a previous call to send email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @param context The context to associate with this operation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a message sent previously along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSendStatusWithResponseAsync(
            String messageId, RequestOptions requestOptions, Context context) {
        final String accept = "application/json";
        return service.getSendStatus(
                this.client.getEndpoint(),
                messageId,
                this.client.getServiceVersion().getVersion(),
                accept,
                requestOptions,
                context);
    }

    /**
     * Gets the status of a message sent previously.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messageId: String
     *     status: String(queued/outForDelivery/dropped)
     * }
     * }</pre>
     *
     * @param messageId System generated message id (GUID) returned from a previous call to send email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a message sent previously along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getSendStatusWithResponse(String messageId, RequestOptions requestOptions) {
        return getSendStatusWithResponseAsync(messageId, requestOptions).block();
    }

    /**
     * Queues an email message to be sent to one or more recipients.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>repeatability-request-id</td><td>String</td><td>No</td><td>Repeatability request ID header</td></tr>
     *     <tr><td>repeatability-first-sent</td><td>String</td><td>No</td><td>Repeatability first sent header as HTTP-date</td></tr>
     * </table>
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     customHeaders: [
     *         {
     *             name: String
     *             value: String
     *         }
     *     ]
     *     sender: String
     *     content: {
     *         subject: String
     *         plainText: String
     *         html: String
     *     }
     *     importance: String(high/normal/low)
     *     recipients: {
     *         to: [
     *             {
     *                 email: String
     *                 displayName: String
     *             }
     *         ]
     *         cc: [
     *             (recursive schema, see above)
     *         ]
     *         bcc: [
     *             (recursive schema, see above)
     *         ]
     *     }
     *     attachments: [
     *         {
     *             name: String
     *             attachmentType: String(avi/bmp/doc/docm/docx/gif/jpeg/mp3/one/pdf/png/ppsm/ppsx/ppt/pptm/pptx/pub/rpmsg/rtf/tif/txt/vsd/wav/wma/xls/xlsb/xlsm/xlsx)
     *             contentBytesBase64: String
     *         }
     *     ]
     *     replyTo: [
     *         (recursive schema, see above)
     *     ]
     *     disableUserEngagementTracking: Boolean
     * }
     * }</pre>
     *
     * @param emailMessage Message payload for sending an email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> sendWithResponseAsync(BinaryData emailMessage, RequestOptions requestOptions) {
        final String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.setHeader("repeatability-request-id", UUID.randomUUID().toString());
        requestOptionsLocal.setHeader(
                "repeatability-first-sent", DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()));
        return FluxUtil.withContext(
                context ->
                        service.send(
                                this.client.getEndpoint(),
                                this.client.getServiceVersion().getVersion(),
                                emailMessage,
                                accept,
                                requestOptionsLocal,
                                context));
    }

    /**
     * Queues an email message to be sent to one or more recipients.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>repeatability-request-id</td><td>String</td><td>No</td><td>Repeatability request ID header</td></tr>
     *     <tr><td>repeatability-first-sent</td><td>String</td><td>No</td><td>Repeatability first sent header as HTTP-date</td></tr>
     * </table>
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     customHeaders: [
     *         {
     *             name: String
     *             value: String
     *         }
     *     ]
     *     sender: String
     *     content: {
     *         subject: String
     *         plainText: String
     *         html: String
     *     }
     *     importance: String(high/normal/low)
     *     recipients: {
     *         to: [
     *             {
     *                 email: String
     *                 displayName: String
     *             }
     *         ]
     *         cc: [
     *             (recursive schema, see above)
     *         ]
     *         bcc: [
     *             (recursive schema, see above)
     *         ]
     *     }
     *     attachments: [
     *         {
     *             name: String
     *             attachmentType: String(avi/bmp/doc/docm/docx/gif/jpeg/mp3/one/pdf/png/ppsm/ppsx/ppt/pptm/pptx/pub/rpmsg/rtf/tif/txt/vsd/wav/wma/xls/xlsb/xlsm/xlsx)
     *             contentBytesBase64: String
     *         }
     *     ]
     *     replyTo: [
     *         (recursive schema, see above)
     *     ]
     *     disableUserEngagementTracking: Boolean
     * }
     * }</pre>
     *
     * @param emailMessage Message payload for sending an email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @param context The context to associate with this operation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> sendWithResponseAsync(
            BinaryData emailMessage, RequestOptions requestOptions, Context context) {
        final String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.setHeader("repeatability-request-id", UUID.randomUUID().toString());
        requestOptionsLocal.setHeader(
                "repeatability-first-sent", DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()));
        return service.send(
                this.client.getEndpoint(),
                this.client.getServiceVersion().getVersion(),
                emailMessage,
                accept,
                requestOptionsLocal,
                context);
    }

    /**
     * Queues an email message to be sent to one or more recipients.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>repeatability-request-id</td><td>String</td><td>No</td><td>Repeatability request ID header</td></tr>
     *     <tr><td>repeatability-first-sent</td><td>String</td><td>No</td><td>Repeatability first sent header as HTTP-date</td></tr>
     * </table>
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     customHeaders: [
     *         {
     *             name: String
     *             value: String
     *         }
     *     ]
     *     sender: String
     *     content: {
     *         subject: String
     *         plainText: String
     *         html: String
     *     }
     *     importance: String(high/normal/low)
     *     recipients: {
     *         to: [
     *             {
     *                 email: String
     *                 displayName: String
     *             }
     *         ]
     *         cc: [
     *             (recursive schema, see above)
     *         ]
     *         bcc: [
     *             (recursive schema, see above)
     *         ]
     *     }
     *     attachments: [
     *         {
     *             name: String
     *             attachmentType: String(avi/bmp/doc/docm/docx/gif/jpeg/mp3/one/pdf/png/ppsm/ppsx/ppt/pptm/pptx/pub/rpmsg/rtf/tif/txt/vsd/wav/wma/xls/xlsb/xlsm/xlsx)
     *             contentBytesBase64: String
     *         }
     *     ]
     *     replyTo: [
     *         (recursive schema, see above)
     *     ]
     *     disableUserEngagementTracking: Boolean
     * }
     * }</pre>
     *
     * @param emailMessage Message payload for sending an email.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> sendWithResponse(BinaryData emailMessage, RequestOptions requestOptions) {
        return sendWithResponseAsync(emailMessage, requestOptions).block();
    }
}
