// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing the email address and its display name. */
@Fluent
public final class EmailAddress {
    /*
     * Email address.
     */
    @JsonProperty(value = "email", required = true)
    private String email;

    /*
     * Email display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /**
     * Constructor for EmailAddress
     * @param email the email address.
     */
    public EmailAddress(String email) {
        this.email = email;
    }

    /**
     * Get the email property: Email address.
     *
     * @return the email value.
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Get the displayName property: Email display name.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Email display name.
     *
     * @param displayName the displayName value to set.
     * @return the EmailAddress object itself.
     */
    public EmailAddress setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }
}
