// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Attachment to the email. */
@Fluent
public final class EmailAttachment {
    /*
     * Name of the attachment
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The type of attachment file.
     */
    @JsonProperty(value = "attachmentType", required = true)
    private EmailAttachmentType attachmentType;

    /*
     * Base64 encoded contents of the attachment
     */
    @JsonProperty(value = "contentBytesBase64", required = true)
    private String contentBytesBase64;

    /**
     * Constructor for EmailAttachment
     * @param name the name of the attachment
     * @param attachmentType the type of attachment file
     * @param contentBytesBase64 the base64 encoded contents of the attachment
     */
    public EmailAttachment(String name, EmailAttachmentType attachmentType, String contentBytesBase64) {
        this.name = name;
        this.attachmentType = attachmentType;
        this.contentBytesBase64 = contentBytesBase64;
    }

    /**
     * Get the name property: Name of the attachment.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the attachmentType property: The type of attachment file.
     *
     * @return the attachmentType value.
     */
    public EmailAttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    /**
     * Get the contentBytesBase64 property: Base64 encoded contents of the attachment.
     *
     * @return the contentBytesBase64 value.
     */
    public String getContentBytesBase64() {
        return this.contentBytesBase64;
    }
}
