// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Custom header for email. */
@Fluent
public final class EmailCustomHeader {
    /*
     * Header name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Header value.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Constructor for EmailCustomHeader
     * @param name the header name
     * @param value the header value
     */
    public EmailCustomHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Get the name property: Header name.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the value property: Header value.
     *
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }
}
