// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Recipients of the email. */
@Fluent
public final class EmailRecipients {
    /*
     * Email To recipients
     */
    @JsonProperty(value = "to", required = true)
    private Iterable<EmailAddress> to;

    /*
     * Email CC recipients
     */
    @JsonProperty(value = "CC")
    private Iterable<EmailAddress> cc;

    /*
     * Email BCC recipients
     */
    @JsonProperty(value = "bCC")
    private Iterable<EmailAddress> bcc;

    /**
     * Constructor for EmailRecipients
     * @param to the email to recipients
     */
    public EmailRecipients(Iterable<EmailAddress> to) {
        this.to = to;
    }

    /**
     * Get the to property: Email To recipients.
     *
     * @return the to value.
     */
    public Iterable<EmailAddress> getTo() {
        return this.to;
    }

    /**
     * Get the cc property: Email CC recipients.
     *
     * @return the cc value.
     */
    public Iterable<EmailAddress> getCc() {
        return this.cc;
    }

    /**
     * Set the cc property: Email CC recipients.
     *
     * @param cc the cc value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setCc(Iterable<EmailAddress> cc) {
        this.cc = cc;
        return this;
    }

    /**
     * Get the bcc property: Email BCC recipients.
     *
     * @return the bcc value.
     */
    public Iterable<EmailAddress> getBcc() {
        return this.bcc;
    }

    /**
     * Set the bcc property: Email BCC recipients.
     *
     * @param bcc the bcc value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setBcc(Iterable<EmailAddress> bcc) {
        this.bcc = bcc;
        return this;
    }
}
