// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SendStatus. */
public final class SendStatus extends ExpandableStringEnum<SendStatus> {
    /** Static value queued for SendStatus. */
    public static final SendStatus QUEUED = fromString("queued");

    /** Static value outForDelivery for SendStatus. */
    public static final SendStatus OUT_FOR_DELIVERY = fromString("outForDelivery");

    /** Static value dropped for SendStatus. */
    public static final SendStatus DROPPED = fromString("dropped");

    /**
     * Creates or finds a SendStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SendStatus.
     */
    @JsonCreator
    public static SendStatus fromString(String name) {
        return fromString(name, SendStatus.class);
    }

    /**
     * Gets known SendStatus values.
     *
     * @return known SendStatus values.
     */
    public static Collection<SendStatus> values() {
        return values(SendStatus.class);
    }
}
