// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Status of an email message that was sent previously. */
@Fluent
public final class SendStatusResult {
    /*
     * System generated id of an email message sent.
     */
    @JsonProperty(value = "messageId", required = true)
    private String messageId;

    /*
     * The type indicating the status of a request.
     */
    @JsonProperty(value = "status", required = true)
    private SendStatus status;

    /**
     * Get the messageId property: System generated id of an email message sent.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: System generated id of an email message sent.
     *
     * @param messageId the messageId value to set.
     * @return the SendStatusResult object itself.
     */
    public SendStatusResult setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the status property: The type indicating the status of a request.
     *
     * @return the status value.
     */
    public SendStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The type indicating the status of a request.
     *
     * @param status the status value to set.
     * @return the SendStatusResult object itself.
     */
    public SendStatusResult setStatus(SendStatus status) {
        this.status = status;
        return this;
    }
}
