/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email;

import com.azure.communication.email.EmailClientBuilder;
import com.azure.communication.email.implementation.EmailsImpl;
import com.azure.communication.email.models.EmailMessage;
import com.azure.communication.email.models.SendEmailResult;
import com.azure.communication.email.models.SendStatusResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.BinaryData;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EmailClientBuilder.class, isAsync=true)
public final class EmailAsyncClient {
    private final EmailsImpl serviceClient;

    EmailAsyncClient(EmailsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendStatusResult> getSendStatus(String messageId) {
        return this.serviceClient.getSendStatusWithResponseAsync(messageId, null).flatMap(response -> Mono.just((Object)((SendStatusResult)((BinaryData)response.getValue()).toObject(SendStatusResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendEmailResult> send(EmailMessage emailMessage) {
        return this.serviceClient.sendWithResponseAsync(BinaryData.fromObject((Object)emailMessage), null).flatMap(response -> {
            SendEmailResult result = new SendEmailResult().setMessageId(response.getHeaders().getValue("x-ms-request-id"));
            return Mono.just((Object)result);
        });
    }
}

