/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email;

import com.azure.communication.email.EmailAsyncClient;
import com.azure.communication.email.EmailClientBuilder;
import com.azure.communication.email.models.EmailMessage;
import com.azure.communication.email.models.SendEmailResult;
import com.azure.communication.email.models.SendStatusResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;

@ServiceClient(builder=EmailClientBuilder.class)
public final class EmailClient {
    private final EmailAsyncClient client;

    EmailClient(EmailAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendStatusResult getSendStatus(String messageId) {
        return (SendStatusResult)this.client.getSendStatus(messageId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendEmailResult send(EmailMessage emailMessage) {
        return (SendEmailResult)this.client.send(emailMessage).block();
    }
}

