/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation;

import com.azure.communication.email.EmailServiceVersion;
import com.azure.communication.email.implementation.EmailsImpl;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

public final class AzureCommunicationServicesClientImpl {
    private final String endpoint;
    private final EmailServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final EmailsImpl emails;

    public String getEndpoint() {
        return this.endpoint;
    }

    public EmailServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EmailsImpl getEmails() {
        return this.emails;
    }

    public AzureCommunicationServicesClientImpl(String endpoint, EmailServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AzureCommunicationServicesClientImpl(HttpPipeline httpPipeline, String endpoint, EmailServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AzureCommunicationServicesClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, EmailServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.emails = new EmailsImpl(this);
    }
}

