/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation;

import com.azure.communication.email.implementation.AzureCommunicationServicesClientImpl;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class EmailsImpl {
    private final EmailsService service;
    private final AzureCommunicationServicesClientImpl client;

    EmailsImpl(AzureCommunicationServicesClientImpl client) {
        this.service = (EmailsService)RestProxy.create(EmailsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSendStatusWithResponseAsync(String messageId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSendStatus(this.client.getEndpoint(), messageId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSendStatusWithResponseAsync(String messageId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getSendStatus(this.client.getEndpoint(), messageId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getSendStatusWithResponse(String messageId, RequestOptions requestOptions) {
        return (Response)this.getSendStatusWithResponseAsync(messageId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendWithResponseAsync(BinaryData emailMessage, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.setHeader("repeatability-request-id", UUID.randomUUID().toString());
        requestOptionsLocal.setHeader("repeatability-first-sent", DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()));
        return FluxUtil.withContext(context -> this.service.send(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), emailMessage, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendWithResponseAsync(BinaryData emailMessage, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.setHeader("repeatability-request-id", UUID.randomUUID().toString());
        requestOptionsLocal.setHeader("repeatability-first-sent", DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()));
        return this.service.send(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), emailMessage, "application/json", requestOptionsLocal, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendWithResponse(BinaryData emailMessage, RequestOptions requestOptions) {
        return (Response)this.sendWithResponseAsync(emailMessage, requestOptions).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationSe")
    private static interface EmailsService {
        @Get(value="/emails/{messageId}/status")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getSendStatus(@HostParam(value="endpoint") String var1, @PathParam(value="messageId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/emails:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> send(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BinaryData var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);
    }
}

