/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.models;

import com.azure.communication.email.models.EmailAddress;
import com.azure.communication.email.models.EmailAttachment;
import com.azure.communication.email.models.EmailContent;
import com.azure.communication.email.models.EmailCustomHeader;
import com.azure.communication.email.models.EmailImportance;
import com.azure.communication.email.models.EmailRecipients;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class EmailMessage {
    @JsonProperty(value="headers")
    private List<EmailCustomHeader> customHeaders;
    @JsonProperty(value="sender", required=true)
    private String sender;
    @JsonProperty(value="content", required=true)
    private EmailContent content;
    @JsonProperty(value="importance")
    private EmailImportance importance;
    @JsonProperty(value="recipients", required=true)
    private EmailRecipients recipients;
    @JsonProperty(value="attachments")
    private Iterable<EmailAttachment> attachments;
    @JsonProperty(value="replyTo")
    private Iterable<EmailAddress> replyTo;
    @JsonProperty(value="disableUserEngagementTracking")
    private Boolean disableUserEngagementTracking;

    public EmailMessage(String sender, EmailContent content) {
        this.sender = sender;
        this.content = content;
    }

    public List<EmailCustomHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    public EmailMessage setCustomHeaders(List<EmailCustomHeader> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public String getSender() {
        return this.sender;
    }

    public EmailContent getContent() {
        return this.content;
    }

    public EmailImportance getImportance() {
        return this.importance;
    }

    public EmailMessage setImportance(EmailImportance importance) {
        this.importance = importance;
        return this;
    }

    public EmailRecipients getRecipients() {
        return this.recipients;
    }

    public EmailMessage setRecipients(EmailRecipients recipients) {
        this.recipients = recipients;
        return this;
    }

    public Iterable<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public EmailMessage setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Iterable<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public EmailMessage setReplyTo(Iterable<EmailAddress> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Boolean isDisableUserEngagementTracking() {
        return this.disableUserEngagementTracking;
    }

    public EmailMessage setDisableUserEngagementTracking(Boolean disableUserEngagementTracking) {
        this.disableUserEngagementTracking = disableUserEngagementTracking;
        return this;
    }
}

