// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing the email address and its display name. */
@Fluent
public final class EmailAddress {
    /*
     * Email address.
     */
    @JsonProperty(value = "address", required = true)
    private String address;

    /*
     * Email display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /**
     * Creates an instance of EmailAddress class.
     *
     * @param address the address value to set.
     */
    @JsonCreator
    public EmailAddress(@JsonProperty(value = "address", required = true) String address) {
        this.address = address;
    }

    /**
     * Get the address property: Email address.
     *
     * @return the address value.
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * Get the displayName property: Email display name.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Email display name.
     *
     * @param displayName the displayName value to set.
     * @return the EmailAddress object itself.
     */
    public EmailAddress setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }
}
