// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Attachment to the email. */
@Immutable
public final class EmailAttachment {
    /*
     * Name of the attachment
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * MIME type of the content being attached.
     */
    @JsonProperty(value = "contentType", required = true)
    private String contentType;

    /*
     * Base64 encoded contents of the attachment
     */
    @JsonProperty(value = "contentInBase64", required = true)
    private String contentInBase64;

    /**
     * Creates an instance of EmailAttachment class.
     *
     * @param name the name value to set.
     * @param contentType the contentType value to set.
     * @param contentInBase64 the contentInBase64 value to set.
     */
    @JsonCreator
    public EmailAttachment(
            @JsonProperty(value = "name", required = true) String name,
            @JsonProperty(value = "contentType", required = true) String contentType,
            @JsonProperty(value = "contentInBase64", required = true) String contentInBase64) {
        this.name = name;
        this.contentType = contentType;
        this.contentInBase64 = contentInBase64;
    }

    /**
     * Get the name property: Name of the attachment.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the contentType property: MIME type of the content being attached.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Get the contentInBase64 property: Base64 encoded contents of the attachment.
     *
     * @return the contentInBase64 value.
     */
    public String getContentInBase64() {
        return this.contentInBase64;
    }
}
