// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.communication.email.models.EmailSendStatus;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Status of the long running operation. */
@Fluent
public final class EmailSendResult {
    /*
     * The unique id of the operation. Use a UUID.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * Status of operation.
     */
    @JsonProperty(value = "status", required = true)
    private EmailSendStatus status;

    /*
     * Error details when status is a non-success terminal state.
     */
    @JsonProperty(value = "error")
    private ErrorDetail error;

    /**
     * Creates an instance of EmailSendResult class.
     *
     * @param id the id value to set.
     * @param status the status value to set.
     */
    @JsonCreator
    public EmailSendResult(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "status", required = true) EmailSendStatus status) {
        this.id = id;
        this.status = status;
    }

    /**
     * Get the id property: The unique id of the operation. Use a UUID.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the status property: Status of operation.
     *
     * @return the status value.
     */
    public EmailSendStatus getStatus() {
        return this.status;
    }

    /**
     * Get the error property: Error details when status is a non-success terminal state.
     *
     * @return the error value.
     */
    public ErrorDetail getError() {
        return this.error;
    }

    /**
     * Set the error property: Error details when status is a non-success terminal state.
     *
     * @param error the error value to set.
     * @return the EmailSendResult object itself.
     */
    public EmailSendResult setError(ErrorDetail error) {
        this.error = error;
        return this;
    }
}
