// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.communication.email.models.EmailAddress;
import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Message payload for sending an email.
 */
@Fluent
public final class EmailMessage implements JsonSerializable<EmailMessage> {
    /*
     * Custom email headers to be passed.
     */
    private Map<String, String> headers;

    /*
     * Sender email address from a verified domain.
     */
    private final String senderAddress;

    /*
     * Email content to be sent.
     */
    private final EmailContent content;

    /*
     * Recipients for the email.
     */
    private final EmailRecipients recipients;

    /*
     * List of attachments. Please note that we limit the total size of an email request (which includes both regular
     * and inline attachments) to 10MB.
     */
    private List<EmailAttachment> attachments;

    /*
     * Email addresses where recipients' replies will be sent to.
     */
    private List<EmailAddress> replyTo;

    /*
     * Indicates whether user engagement tracking should be disabled for this request if the resource-level user
     * engagement tracking setting was already enabled in the control plane.
     */
    private Boolean userEngagementTrackingDisabled;

    /**
     * Creates an instance of EmailMessage class.
     *
     * @param senderAddress the senderAddress value to set.
     * @param content the content value to set.
     * @param recipients the recipients value to set.
     */
    public EmailMessage(String senderAddress, EmailContent content, EmailRecipients recipients) {
        this.senderAddress = senderAddress;
        this.content = content;
        this.recipients = recipients;
    }

    /**
     * Get the headers property: Custom email headers to be passed.
     *
     * @return the headers value.
     */
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /**
     * Set the headers property: Custom email headers to be passed.
     *
     * @param headers the headers value to set.
     * @return the EmailMessage object itself.
     */
    public EmailMessage setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the senderAddress property: Sender email address from a verified domain.
     *
     * @return the senderAddress value.
     */
    public String getSenderAddress() {
        return this.senderAddress;
    }

    /**
     * Get the content property: Email content to be sent.
     *
     * @return the content value.
     */
    public EmailContent getContent() {
        return this.content;
    }

    /**
     * Get the recipients property: Recipients for the email.
     *
     * @return the recipients value.
     */
    public EmailRecipients getRecipients() {
        return this.recipients;
    }

    /**
     * Get the attachments property: List of attachments. Please note that we limit the total size of an email request
     * (which includes both regular and inline attachments) to 10MB.
     *
     * @return the attachments value.
     */
    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: List of attachments. Please note that we limit the total size of an email request
     * (which includes both regular and inline attachments) to 10MB.
     *
     * @param attachments the attachments value to set.
     * @return the EmailMessage object itself.
     */
    public EmailMessage setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the replyTo property: Email addresses where recipients' replies will be sent to.
     *
     * @return the replyTo value.
     */
    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    /**
     * Set the replyTo property: Email addresses where recipients' replies will be sent to.
     *
     * @param replyTo the replyTo value to set.
     * @return the EmailMessage object itself.
     */
    public EmailMessage setReplyTo(List<EmailAddress> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    /**
     * Get the userEngagementTrackingDisabled property: Indicates whether user engagement tracking should be disabled
     * for this request if the resource-level user engagement tracking setting was already enabled in the control plane.
     *
     * @return the userEngagementTrackingDisabled value.
     */
    public Boolean isUserEngagementTrackingDisabled() {
        return this.userEngagementTrackingDisabled;
    }

    /**
     * Set the userEngagementTrackingDisabled property: Indicates whether user engagement tracking should be disabled
     * for this request if the resource-level user engagement tracking setting was already enabled in the control plane.
     *
     * @param userEngagementTrackingDisabled the userEngagementTrackingDisabled value to set.
     * @return the EmailMessage object itself.
     */
    public EmailMessage setUserEngagementTrackingDisabled(Boolean userEngagementTrackingDisabled) {
        this.userEngagementTrackingDisabled = userEngagementTrackingDisabled;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("senderAddress", this.senderAddress);
        jsonWriter.writeJsonField("content", this.content);
        jsonWriter.writeJsonField("recipients", this.recipients);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("replyTo", this.replyTo, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("userEngagementTrackingDisabled", this.userEngagementTrackingDisabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmailMessage.
     */
    public static EmailMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean senderAddressFound = false;
            String senderAddress = null;
            boolean contentFound = false;
            EmailContent content = null;
            boolean recipientsFound = false;
            EmailRecipients recipients = null;
            Map<String, String> headers = null;
            List<EmailAttachment> attachments = null;
            List<EmailAddress> replyTo = null;
            Boolean userEngagementTrackingDisabled = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("senderAddress".equals(fieldName)) {
                    senderAddress = reader.getString();
                    senderAddressFound = true;
                } else if ("content".equals(fieldName)) {
                    content = EmailContent.fromJson(reader);
                    contentFound = true;
                } else if ("recipients".equals(fieldName)) {
                    recipients = EmailRecipients.fromJson(reader);
                    recipientsFound = true;
                } else if ("headers".equals(fieldName)) {
                    headers = reader.readMap(reader1 -> reader1.getString());
                } else if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> EmailAttachment.fromJson(reader1));
                } else if ("replyTo".equals(fieldName)) {
                    replyTo = reader.readArray(reader1 -> EmailAddress.fromJson(reader1));
                } else if ("userEngagementTrackingDisabled".equals(fieldName)) {
                    userEngagementTrackingDisabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (senderAddressFound && contentFound && recipientsFound) {
                EmailMessage deserializedEmailMessage = new EmailMessage(senderAddress, content, recipients);
                deserializedEmailMessage.headers = headers;
                deserializedEmailMessage.attachments = attachments;
                deserializedEmailMessage.replyTo = replyTo;
                deserializedEmailMessage.userEngagementTrackingDisabled = userEngagementTrackingDisabled;

                return deserializedEmailMessage;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!senderAddressFound) {
                missingProperties.add("senderAddress");
            }
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!recipientsFound) {
                missingProperties.add("recipients");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
